/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.client.redis.client.DatarouterRedisClient;
import io.datarouter.client.redis.client.RedisRequestConfig;
import io.datarouter.client.redis.codec.RedisTallyCodec;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.tally.Tally;
import io.datarouter.storage.tally.TallyKey;
import io.lettuce.core.Value;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class RedisTallyNode
extends BasePhysicalNode<TallyKey, Tally, Tally.TallyFielder>
implements TallyStorage.PhysicalTallyStorageNode {
    private final RedisTallyCodec codec;
    private final Supplier<DatarouterRedisClient> lazyClient;

    public RedisTallyNode(NodeParams<TallyKey, Tally, Tally.TallyFielder> params, ClientType<?, ?> clientType, RedisTallyCodec codec, Supplier<DatarouterRedisClient> lazyClient) {
        super(params, clientType);
        this.codec = codec;
        this.lazyClient = lazyClient;
    }

    public Long incrementAndGetCount(String id, int delta, Config config) {
        byte[] encodedId = this.codec.encodeId(id);
        long count = this.lazyClient.get().incrby(encodedId, delta, RedisRequestConfig.forWrite(this.getName(), config));
        config.findTtl().ifPresent(ttl -> this.lazyClient.get().pexpire(encodedId, (Duration)ttl, RedisRequestConfig.forWrite(this.getName(), config)));
        return count;
    }

    public Optional<Long> findTallyCount(String id, Config config) {
        return Optional.of(id).map(this.codec::encodeId).flatMap(encodedId -> this.lazyClient.get().find((byte[])encodedId, RedisRequestConfig.forRead(this.getName(), config))).map(this.codec::decodeValue);
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> ids, Config config) {
        return ((Scanner)Scanner.of(ids).map(this.codec::encodeId).listTo(encodedIds -> this.lazyClient.get().mget((List<byte[]>)encodedIds, RedisRequestConfig.forRead(this.getName(), config)))).include(Value::hasValue).toMap(this.codec::decodeId, this.codec::decodeValue);
    }

    public void deleteTally(String id, Config config) {
        Optional.of(id).map(this.codec::encodeId).ifPresent(encodedKey -> this.lazyClient.get().del((byte[])encodedKey, RedisRequestConfig.forWrite(this.getName(), config)));
    }

    public void vacuum(Config config) {
        throw new UnsupportedOperationException();
    }
}

