/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.bytes.InputStreamTool;
import io.datarouter.client.redis.client.DatarouterRedisClient;
import io.datarouter.client.redis.client.RedisKeyValue;
import io.datarouter.client.redis.client.RedisRequestConfig;
import io.datarouter.client.redis.codec.RedisBlobCodec;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.DatabaseBlob;
import io.datarouter.storage.file.DatabaseBlobKey;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.util.Subpath;
import io.lettuce.core.Value;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class RedisBlobNode
extends BasePhysicalNode<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder>
implements BlobStorage.PhysicalBlobStorageNode {
    private final Supplier<DatarouterRedisClient> lazyClient;
    private final String bucket;
    private final Subpath rootPath;
    private final RedisBlobCodec codec;

    public RedisBlobNode(NodeParams<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder> params, ClientType<?, ?> clientType, RedisBlobCodec codec, Supplier<DatarouterRedisClient> lazyClient) {
        super(params, clientType);
        this.codec = codec;
        this.lazyClient = lazyClient;
        this.bucket = params.getPhysicalName();
        this.rootPath = params.getPath();
    }

    public String getBucket() {
        return this.bucket;
    }

    public Subpath getRootPath() {
        return this.rootPath;
    }

    public boolean exists(PathbeanKey key, Config config) {
        return Optional.of(key).map(this.codec::encodeKey).map(encodedKey -> this.lazyClient.get().exists((byte[])encodedKey, RedisRequestConfig.forRead(this.getName(), config))).orElseThrow();
    }

    public Optional<Long> length(PathbeanKey key, Config config) {
        return Optional.of(key).map(this.codec::encodeKey).flatMap(encodedKey -> this.lazyClient.get().find((byte[])encodedKey, RedisRequestConfig.forRead(this.getName(), config))).map(value -> ((byte[])value).length).map(Integer::longValue);
    }

    public byte[] read(PathbeanKey key, Config config) {
        return Optional.of(key).map(this.codec::encodeKey).flatMap(encodedKey -> this.lazyClient.get().find((byte[])encodedKey, RedisRequestConfig.forRead(this.getName(), config))).orElse(null);
    }

    public byte[] read(PathbeanKey key, long offset, int length, Config config) {
        int from = (int)offset;
        int to = from + length;
        return Optional.of(key).map(this.codec::encodeKey).flatMap(encodedKey -> this.lazyClient.get().find((byte[])encodedKey, RedisRequestConfig.forRead(this.getName(), config))).map(bytes -> Arrays.copyOfRange(bytes, from, to)).orElse(null);
    }

    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> keys, Config config) {
        return ((Scanner)Scanner.of(keys).map(this.codec::encodeKey).listTo(encodedKeys -> this.lazyClient.get().mget((List<byte[]>)encodedKeys, RedisRequestConfig.forRead(this.getName(), config)))).include(Value::hasValue).toMap(this.codec::decodeKey, Value::getValue);
    }

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath, Config config) {
        throw new UnsupportedOperationException();
    }

    public Scanner<List<Pathbean>> scanPaged(Subpath subpath, Config config) {
        throw new UnsupportedOperationException();
    }

    public void write(PathbeanKey key, byte[] value, Config config) {
        RedisKeyValue kv = new RedisKeyValue(this.codec.encodeKey(key), value);
        config.findTtl().map(Duration::toMillis).ifPresentOrElse(ttlMs -> this.lazyClient.get().psetex(kv, (long)ttlMs, RedisRequestConfig.forWrite(this.getName(), config)), () -> this.lazyClient.get().set(kv, RedisRequestConfig.forWrite(this.getName(), config)));
    }

    public void write(PathbeanKey key, InputStream inputStream, Config config) {
        byte[] value = InputStreamTool.toArray((InputStream)inputStream);
        this.write(key, value, config);
    }

    public void delete(PathbeanKey key, Config config) {
        Optional.of(key).map(this.codec::encodeKey).ifPresent(encodedKey -> this.lazyClient.get().del((byte[])encodedKey, RedisRequestConfig.forWrite(this.getName(), config)));
    }

    public void deleteMulti(List<PathbeanKey> keys, Config config) {
        this.lazyClient.get().del(this.codec.encodeKeys(keys), RedisRequestConfig.forWrite(this.getName(), config));
    }

    public void deleteAll(Subpath subpath, Config config) {
        throw new UnsupportedOperationException();
    }

    public void vacuum(Config config) {
        throw new UnsupportedOperationException();
    }
}

