/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsBuilder;
import io.datarouter.storage.config.client.RedisGenericClientOptions;
import java.util.Properties;

public class RedisClientOptionsBuilder
implements ClientOptionsBuilder {
    private final String clientIdName;
    private final Properties properties;

    public RedisClientOptionsBuilder(RedisGenericClientOptions genericOptions) {
        this(genericOptions.clientId);
        this.withClientMode(RedisOptions.RedisClientMode.fromGenericClientMode(genericOptions.clientMode));
        this.withEndpoint(genericOptions.endpoint);
    }

    public RedisClientOptionsBuilder(ClientId clientId) {
        this.clientIdName = clientId.getName();
        this.properties = new Properties();
        this.properties.setProperty(ClientOptions.makeClientTypeKey((String)this.clientIdName), "redis");
    }

    public RedisClientOptionsBuilder withEndpoint(String endpoint) {
        String optionKeySuffix = RedisOptions.makeRedisKey("endpoint");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, endpoint);
        return this;
    }

    public RedisClientOptionsBuilder withNumNodes(int numberOfNodes) {
        String optionKeySuffix = RedisOptions.makeRedisKey("numNodes");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, String.valueOf(numberOfNodes));
        return this;
    }

    public RedisClientOptionsBuilder withNodeIndexAndHostAndPort(int nodeIndex, String inetSocketAddress) {
        String optionKeySuffix = RedisOptions.makeRedisKey("node." + nodeIndex);
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, inetSocketAddress);
        return this;
    }

    public RedisClientOptionsBuilder withClientMode(RedisOptions.RedisClientMode clientMode) {
        String optionKeySuffix = RedisOptions.makeRedisKey("clientMode");
        String optionKey = this.makeKey(optionKeySuffix);
        this.properties.setProperty(optionKey, clientMode.persistentString);
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    private String makeKey(String suffix) {
        return ClientOptions.makeClientPrefixedKey((String)this.clientIdName, (String)suffix);
    }
}

