/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis;

import io.datarouter.bytes.ByteLength;
import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.codec.RedisBlobCodec;
import io.datarouter.client.redis.codec.RedisTallyCodec;
import io.datarouter.client.redis.node.RedisBlobNode;
import io.datarouter.client.redis.node.RedisTallyNode;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.imp.BlobClientNodeFactory;
import io.datarouter.storage.client.imp.DatabeanClientNodeFactory;
import io.datarouter.storage.client.imp.TallyClientNodeFactory;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.file.DatabaseBlob;
import io.datarouter.storage.file.DatabaseBlobKey;
import io.datarouter.storage.file.ReservedBlobPaths;
import io.datarouter.storage.node.DatabeanNodePrefix;
import io.datarouter.storage.node.DatabeanToBlobCodec;
import io.datarouter.storage.node.DatabeanToBlobNode;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.NodeAdapters;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.storage.tally.Tally;
import io.datarouter.storage.tally.TallyKey;
import io.datarouter.storage.util.Subpath;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RedisClientNodeFactory
implements BlobClientNodeFactory,
DatabeanClientNodeFactory,
TallyClientNodeFactory {
    private static final int MAX_REDIS_KEY_SIZE = ByteLength.ofKiB((long)64L).toBytesInt();
    private static final int MAX_REDIS_VALUE_SIZE = Integer.MAX_VALUE;
    @Inject
    private RedisClientType redisClientType;
    @Inject
    private RedisClientManager redisClientManager;
    @Inject
    private NodeAdapters nodeAdapters;
    @Inject
    private ServiceName serviceName;

    public BlobStorage.PhysicalBlobStorageNode createBlobNode(NodeParams<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder> nodeParams) {
        RedisBlobCodec codec = new RedisBlobCodec(nodeParams.getPath());
        RedisBlobNode node = new RedisBlobNode(nodeParams, this.redisClientType, codec, this.redisClientManager.getLazyClient(nodeParams.getClientId()));
        return this.nodeAdapters.wrapBlobNode((BlobStorage.PhysicalBlobStorageNode)node);
    }

    public <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createDatabeanNode(EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> nodeParams) {
        PhysicalDatabeanFieldInfo fieldInfo = new PhysicalDatabeanFieldInfo(nodeParams);
        Subpath path = new DatabeanNodePrefix(ReservedBlobPaths.DATABEAN, "1", this.serviceName.get(), "1", nodeParams, fieldInfo).makeSubpath();
        NodeParams blobParams = new NodeParams.NodeParamsBuilder(nodeParams).withPath(path).build();
        RedisBlobNode blobNode = new RedisBlobNode(this.castParams(blobParams), this.redisClientType, new RedisBlobCodec(path), this.redisClientManager.getLazyClient(nodeParams.getClientId()));
        DatabeanToBlobCodec codec = new DatabeanToBlobCodec(this.redisClientType.getName(), fieldInfo.getSampleFielder(), fieldInfo.getDatabeanSupplier(), fieldInfo.getFieldByPrefixedName(), path, MAX_REDIS_KEY_SIZE, Integer.MAX_VALUE);
        DatabeanToBlobNode node = new DatabeanToBlobNode(nodeParams, (ClientType)this.redisClientType, (BlobStorage.PhysicalBlobStorageNode)blobNode, codec);
        return this.nodeAdapters.wrapDatabeanMapNode((MapStorage.PhysicalMapStorageNode)node);
    }

    private NodeParams<DatabaseBlobKey, DatabaseBlob, DatabaseBlob.DatabaseBlobFielder> castParams(NodeParams<?, ?, ?> params) {
        return params;
    }

    public TallyStorage.PhysicalTallyStorageNode createTallyNode(NodeParams<TallyKey, Tally, Tally.TallyFielder> nodeParams) {
        PhysicalDatabeanFieldInfo fieldInfo = new PhysicalDatabeanFieldInfo(nodeParams);
        Subpath path = new DatabeanNodePrefix(ReservedBlobPaths.TALLY, "1", this.serviceName.get(), "1", nodeParams, fieldInfo).makeSubpath();
        RedisTallyCodec codec = new RedisTallyCodec(path);
        RedisTallyNode node = new RedisTallyNode(nodeParams, this.redisClientType, codec, this.redisClientManager.getLazyClient(nodeParams.getClientId()));
        return this.nodeAdapters.wrapTallyNode((TallyStorage.PhysicalTallyStorageNode)node);
    }
}

