/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.client.DatarouterRedisClient;
import io.datarouter.client.redis.client.RedisOptions;
import io.datarouter.storage.client.ClientId;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class RedisClientHolder {
    private final Map<ClientId, DatarouterRedisClient> redisByClientId = new ConcurrentHashMap<ClientId, DatarouterRedisClient>();

    @Inject
    public RedisClientHolder(RedisOptions redisOptions) {
    }

    public void registerClient(ClientId clientId, DatarouterRedisClient client) {
        if (this.redisByClientId.containsKey(clientId)) {
            throw new RuntimeException(clientId + " already registered a RedisClient");
        }
        this.redisByClientId.put(clientId, client);
    }

    public DatarouterRedisClient get(ClientId clientId) {
        return this.redisByClientId.get(clientId);
    }
}

