/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisRequestConfig;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.util.tuple.Twin;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterRedisClient {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterRedisClient.class);
    private final RedisClientType clientType;
    private final ClientId clientId;
    private final RedisClusterAsyncCommands<byte[], byte[]> lettuceClient;

    public DatarouterRedisClient(RedisClientType clientType, ClientId clientId, RedisClusterAsyncCommands<byte[], byte[]> lettuceClient) {
        this.clientType = clientType;
        this.clientId = clientId;
        this.lettuceClient = lettuceClient;
    }

    public RedisClusterAsyncCommands<byte[], byte[]> getLettuceClient() {
        return this.lettuceClient;
    }

    public boolean exists(byte[] key, RedisRequestConfig config) {
        long numFound = this.exec("exists", () -> this.lettuceClient.exists((Object[])new byte[][]{key}), config, 0L);
        return numFound == 1L;
    }

    public Optional<byte[]> find(byte[] key, RedisRequestConfig config) {
        byte[] value = this.exec("get", () -> this.lettuceClient.get((Object)key), config, null);
        return Optional.ofNullable(value);
    }

    public Scanner<KeyValue<byte[], byte[]>> mget(List<byte[]> keys, RedisRequestConfig config) {
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        List values = this.exec("mget", () -> this.lettuceClient.mget((Object[])keysArray), config, List.of());
        return Scanner.of(values);
    }

    public void set(Twin<byte[]> kv, RedisRequestConfig config) {
        this.exec("set", () -> this.lettuceClient.set((Object)((byte[])kv.getLeft()), (Object)((byte[])kv.getRight())), config, null);
    }

    public Long incrby(byte[] key, int by, RedisRequestConfig config) {
        Long newValue = this.exec("incrby", () -> this.lettuceClient.incrby((Object)key, (long)by), config, null);
        return newValue;
    }

    public void pexpire(byte[] key, Duration ttl, RedisRequestConfig config) {
        this.exec("pexpire", () -> this.lettuceClient.pexpire((Object)key, ttl.toMillis()), config, null);
    }

    public void psetex(Twin<byte[]> kv, long ttlMs, RedisRequestConfig config) {
        this.exec("psetex", () -> this.lettuceClient.psetex((Object)((byte[])kv.getLeft()), ttlMs, (Object)((byte[])kv.getRight())), config, null);
    }

    public void del(byte[] key, RedisRequestConfig config) {
        this.exec("del", () -> this.lettuceClient.del((Object[])new byte[][]{key}), config, null);
    }

    /*
     * Exception decompiling
     */
    private <T> T exec(String operationName, Supplier<RedisFuture<T>> operation, RedisRequestConfig config, T responseOnFailure) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

