/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.web;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.PreTag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisWebInspector
implements DatarouterClientWebInspector {
    private static final Logger logger = LoggerFactory.getLogger(RedisWebInspector.class);
    @Inject
    private RedisClientManager clientManager;
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ClientOptions clientOptions;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, RedisClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        if (this.clientManager.getMode(clientId).isStandard()) {
            return this.inspectRegularRedis(clientId, request);
        }
        return this.inspectClusterClient(clientId, request);
    }

    private Mav inspectRegularRedis(ClientId clientId, HttpServletRequest request) {
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{this.buildClientPageHeader(clientName), this.buildClientOptionsTable(allClientOptions), this.buildRegularOverview(clientId)}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - Redis").withContent((DomContent)content).buildMav();
    }

    private ContainerTag<?> buildRegularOverview(ClientId clientId) {
        PreTag infoDiv = null;
        try {
            infoDiv = TagCreator.pre((String)((String)this.clientManager.getClient(clientId).info().get()));
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
        return TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Info:"), TagCreator.dd((DomContent[])new DomContent[]{infoDiv})});
    }

    private Mav inspectClusterClient(ClientId clientId, HttpServletRequest request) {
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        ContainerTag<?> overview = null;
        try {
            overview = this.buildClusterOverview(clientId);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{this.buildClientPageHeader(clientName), this.buildClientOptionsTable(allClientOptions), overview}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - Redis-Cluster").withContent((DomContent)content).buildMav();
    }

    private ContainerTag<?> buildClusterOverview(ClientId clientId) throws InterruptedException, ExecutionException {
        RedisClusterAsyncCommands<byte[], byte[]> client = this.clientManager.getClient(clientId);
        List clusterNodes = Scanner.of((Object[])((String)client.clusterNodes().get()).split("\n")).list();
        String clusterInfo = (String)client.clusterInfo().get();
        String info = (String)client.info().get();
        return TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)("Nodes: " + clusterNodes.size())), TagCreator.dd((DomContent[])new DomContent[]{TagCreator.ul((DomContent[])new DomContent[]{TagCreator.each((Collection)clusterNodes, tag -> TagCreator.li((String)tag))})}), TagCreator.dt((String)"Cluster Info:"), TagCreator.dd((DomContent[])new DomContent[]{TagCreator.pre((String)clusterInfo)}), TagCreator.dt((String)"Info:"), TagCreator.dd((DomContent[])new DomContent[]{TagCreator.pre((String)info)})});
    }
}

