/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.client.redis.RedisDatabeanCodec;
import io.datarouter.client.redis.RedisTallyCodec;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.client.redis.client.RedisNodeOps;
import io.datarouter.client.redis.client.RedisOps;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.TallyStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class RedisNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements TallyStorage.PhysicalTallyStorageNode<PK, D, F> {
    private final ExecutorService executor;
    private final RedisDatabeanCodec<PK, D, F> codec;
    private final RedisTallyCodec tallyCodec;
    private final RedisClientManager redisClientManager;
    private final ClientId clientId;

    public RedisNode(NodeParams<PK, D, F> params, ClientType<?, ?> clientType, RedisClientManager redisClientManager, ExecutorService executor) {
        super(params, clientType);
        this.executor = executor;
        int version = Optional.ofNullable(params.getSchemaVersion()).orElse(1);
        this.codec = new RedisDatabeanCodec(version, this.getFieldInfo());
        this.tallyCodec = new RedisTallyCodec(version, this.getFieldInfo());
        this.redisClientManager = redisClientManager;
        this.clientId = params.getClientId();
    }

    public boolean exists(PK key, Config config) {
        return this.nodeOps().nodeExists(key);
    }

    public D get(PK key, Config config) {
        return this.nodeOps().nodeGet(key);
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        return this.nodeOps().nodeGetMulti(keys);
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        if (keys.isEmpty()) {
            return List.of();
        }
        return this.scanMulti(keys, config).map(Databean::getKey).list();
    }

    public void put(D databean, Config config) {
        this.nodeOps().clientPut(databean, config);
    }

    public void putMulti(Collection<D> databeans, Config config) {
        this.nodeOps().nodePutMulti(databeans, config);
    }

    public void deleteAll(Config config) {
        throw new UnsupportedOperationException();
    }

    public void delete(PK key, Config config) {
        this.nodeOps().nodeDelete(key);
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        this.nodeOps().nodeDeleteMulti(keys);
    }

    public Optional<Long> findTallyCount(String stringKey, Config config) {
        return this.nodeOps().nodeFindTallyCount(stringKey);
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> stringKeys, Config config) {
        return this.nodeOps().getMultiTallyCount(stringKeys);
    }

    public Long incrementAndGetCount(String stringKey, int delta, Config config) {
        return this.nodeOps().nodeIncrementAndGetCount(stringKey, delta, config);
    }

    public void deleteTally(String stringKey, Config config) {
        this.nodeOps().nodeDeleteTally(stringKey);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> client() {
        return this.redisClientManager.getClient(this.clientId);
    }

    private RedisOps ops() {
        return new RedisOps(this.client());
    }

    private RedisNodeOps<PK, D, F> nodeOps() {
        return new RedisNodeOps<PK, D, F>(this.ops(), this.client(), this.codec, this.tallyCodec, this.executor);
    }
}

