/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter;

import io.datarouter.instrumentation.metric.Metrics;
import io.datarouter.ratelimiter.DatarouterRateLimiterConfig;
import io.datarouter.ratelimiter.storage.BaseTallyDao;
import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.time.ZoneIds;
import io.datarouter.web.util.http.RequestTool;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class DatarouterRateLimiter {
    private static final String HIT_COUNTER_NAME = "rate limit hit";
    private static final String EXCEEDED_AVG = "rate limit exceeded avg";
    private static final String EXCEEDED_PEAK = "rate limit exceeded peak";
    private static final String COUNTER_PREFIX = "RateLimiter ";
    private final BaseTallyDao tallyDao;
    private final DatarouterRateLimiterConfig config;

    public DatarouterRateLimiter(BaseTallyDao tallyDao, DatarouterRateLimiterConfig config) {
        this.tallyDao = tallyDao;
        this.config = config;
    }

    public boolean peek(String key) {
        return this.internalAllow(this.makeKey(key), false);
    }

    public boolean allowed() {
        return this.allowed("");
    }

    public boolean allowed(String dynamicKey) {
        boolean allowed = this.internalAllow(this.makeKey(dynamicKey), true);
        if (allowed) {
            Metrics.count((String)(COUNTER_PREFIX + this.config.name + " allowed"));
        } else {
            Metrics.count((String)(COUNTER_PREFIX + this.config.name + " limit reached"));
        }
        return allowed;
    }

    public boolean allowedForIp(HttpServletRequest request) {
        return this.allowedForIp("", request);
    }

    public boolean allowedForIp(String dynamicKey, HttpServletRequest request) {
        String ip = RequestTool.getIpAddress((HttpServletRequest)request);
        boolean allowed = this.internalAllow(this.makeKey(dynamicKey, ip), true);
        if (allowed) {
            Metrics.count((String)("RateLimiter ip " + this.config.name + " allowed"));
        } else {
            Metrics.count((String)("RateLimiter ip " + this.config.name + " limit reached"));
        }
        return allowed;
    }

    public String getName() {
        return this.config.name;
    }

    protected Long increment(String key) {
        return this.tallyDao.incrementAndGetCount(key, 1, this.config.expiration, Duration.ofMillis(200L));
    }

    protected boolean internalAllow(String key, boolean increment) {
        Instant now = Instant.now();
        Map<String, Long> results = this.readCounts(this.buildKeysToRead(key, now));
        String currentMapKey = DatarouterRateLimiter.makeMapKey(key, this.getTimeStr(now));
        int total = 0;
        for (Map.Entry<String, Long> entry : results.entrySet()) {
            Long numRequests = entry.getValue() == null ? 0L : entry.getValue();
            if (entry.getKey().equals(currentMapKey)) {
                numRequests = numRequests + 1L;
            }
            if (numRequests > this.config.maxSpikeRequests) {
                Metrics.count((String)HIT_COUNTER_NAME);
                Metrics.count((String)EXCEEDED_PEAK);
                Metrics.count((String)(COUNTER_PREFIX + this.config.name + " rate limit exceeded peak"));
                return false;
            }
            total = (int)((long)total + numRequests);
        }
        double avgRequests = (double)total / (double)this.config.numIntervals.intValue();
        if (avgRequests > (double)this.config.maxAverageRequests.longValue()) {
            List instants = Scanner.of(results.keySet()).map(DatarouterRateLimiter::getDateFromKey).list();
            Instant lastTime = Instant.MIN;
            for (Instant instant : instants) {
                if (!instant.isAfter(lastTime)) continue;
                lastTime = instant;
            }
            Objects.requireNonNull(lastTime);
            Metrics.count((String)HIT_COUNTER_NAME);
            Metrics.count((String)EXCEEDED_AVG);
            Metrics.count((String)(COUNTER_PREFIX + this.config.name + " rate limit exceeded avg"));
            return false;
        }
        if (increment) {
            this.increment(currentMapKey);
        }
        return true;
    }

    protected String getTimeStr(Instant instant) {
        ChronoField chornoField = switch (this.config.unit) {
            case TimeUnit.DAYS -> ChronoField.DAY_OF_MONTH;
            case TimeUnit.HOURS -> ChronoField.HOUR_OF_DAY;
            case TimeUnit.MINUTES -> ChronoField.MINUTE_OF_HOUR;
            case TimeUnit.SECONDS -> ChronoField.SECOND_OF_MINUTE;
            default -> ChronoField.MILLI_OF_SECOND;
        };
        Instant truncatedInstant = DatarouterRateLimiter.setCalendarFieldForBucket(instant, this.config.unit, chornoField, this.config.bucketTimeInterval);
        return DateTimeFormatter.ISO_INSTANT.format(truncatedInstant);
    }

    private Map<String, Long> readCounts(List<String> keys) {
        return this.tallyDao.getMultiTallyCount(keys, this.config.expiration, Duration.ofMillis(200L));
    }

    private List<String> buildKeysToRead(String key, Instant instant) {
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        while (i < this.config.numIntervals) {
            int amount = i * this.config.bucketIntervalMs;
            String mapKey = DatarouterRateLimiter.makeMapKey(key, this.getTimeStr(instant.minusMillis(amount)));
            keys.add(mapKey.toString());
            ++i;
        }
        return keys;
    }

    private static String makeMapKey(String key, String time) {
        return key.replaceAll("!", "%21") + "!" + time;
    }

    private static KeyTime unmakeMapKey(String mapKey) {
        String[] splits = mapKey.split("!");
        return new KeyTime(splits[0].replaceAll("%21", "!"), splits[1]);
    }

    private static Instant getDateFromKey(String key) {
        String dateString = DatarouterRateLimiter.unmakeMapKey(key).time();
        try {
            return Instant.parse(dateString);
        }
        catch (DateTimeParseException e) {
            throw new IllegalStateException("unparseable key " + key, e);
        }
    }

    private static Instant setCalendarFieldForBucket(Instant instant, TimeUnit timeUnit, ChronoField chronoField, int fieldInterval) {
        ZonedDateTime zonedDateTime = instant.atZone(ZoneIds.UTC);
        long newTemporalvalue = (long)fieldInterval * (zonedDateTime.getLong(chronoField) / (long)fieldInterval);
        if (timeUnit == TimeUnit.DAYS && newTemporalvalue == 0L) {
            return zonedDateTime.truncatedTo(timeUnit.toChronoUnit()).with(chronoField, 1L).minusDays(1L).toInstant();
        }
        return zonedDateTime.truncatedTo(timeUnit.toChronoUnit()).with(chronoField, newTemporalvalue).toInstant();
    }

    private String makeKey(String ... keyFields) {
        return (String)ObjectScanner.of((Object)this.config.name).append((Object[])keyFields).exclude(String::isBlank).collect(Collectors.joining("_"));
    }

    private record KeyTime(String key, String time) {
    }
}

