/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.opencensus.adapter.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.opencensus.adapter.OpencensusAdapter;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.write.MapStorageWriter;
import io.opencensus.common.Scope;
import java.util.Collection;
import java.util.Optional;

public interface MapStorageWriterOpencensusAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorage.MapStorageNode<PK, D, F>>
extends MapStorageWriter<PK, D>,
OpencensusAdapter {
    public N getBackingNode();

    default public void put(D databean, Config config) {
        Optional span = this.startSpan();
        try {
            this.getBackingNode().put(databean, config);
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public void putMulti(Collection<D> databeans, Config config) {
        Optional span = this.startSpan();
        try {
            this.getBackingNode().putMulti(databeans, config);
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public void delete(PK key, Config config) {
        Optional span = this.startSpan();
        try {
            this.getBackingNode().delete(key, config);
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public void deleteMulti(Collection<PK> keys, Config config) {
        Optional span = this.startSpan();
        try {
            this.getBackingNode().deleteMulti(keys, config);
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public void deleteAll(Config config) {
        Optional span = this.startSpan();
        try {
            this.getBackingNode().deleteAll(config);
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }
}

