/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.opencensus.adapter.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.unique.UniqueKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.opencensus.adapter.OpencensusAdapter;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.IndexedStorage;
import io.datarouter.storage.node.type.index.ManagedNode;
import io.datarouter.storage.serialize.fieldcache.IndexEntryFieldInfo;
import io.datarouter.util.tuple.Range;
import io.opencensus.common.Scope;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public interface IndexedStorageOpencensusAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends IndexedStorage.IndexedStorageNode<PK, D, F>>
extends IndexedStorage<PK, D>,
OpencensusAdapter {
    public N getBackingNode();

    default public void deleteUnique(UniqueKey<PK> uniqueKey, Config config) {
        Optional span = this.startSpan();
        try {
            this.getBackingNode().deleteUnique(uniqueKey, config);
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public void deleteMultiUnique(Collection<? extends UniqueKey<PK>> uniqueKeys, Config config) {
        Optional span = this.startSpan();
        try {
            this.getBackingNode().deleteMultiUnique(uniqueKeys, config);
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> void deleteByIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        Optional span = this.startSpan();
        try {
            this.getBackingNode().deleteByIndex(keys, config, indexEntryFieldInfo);
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public D lookupUnique(UniqueKey<PK> uniqueKey, Config config) {
        Optional span = this.startSpan();
        try {
            Databean databean = this.getBackingNode().lookupUnique(uniqueKey, config);
            return (D)databean;
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public List<D> lookupMultiUnique(Collection<? extends UniqueKey<PK>> uniqueKeys, Config config) {
        Optional span = this.startSpan();
        try {
            List list = this.getBackingNode().lookupMultiUnique(uniqueKeys, config);
            return list;
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> List<IE> getMultiFromIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        Optional span = this.startSpan();
        try {
            List list = this.getBackingNode().getMultiFromIndex(keys, config, indexEntryFieldInfo);
            return list;
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> List<D> getMultiByIndex(Collection<IK> keys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        Optional span = this.startSpan();
        try {
            List list = this.getBackingNode().getMultiByIndex(keys, config, indexEntryFieldInfo);
            return list;
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<IE> scanRangesIndex(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        Optional span = this.startSpan();
        try {
            Scanner scanner = this.getBackingNode().scanRangesIndex(indexEntryFieldInfo, ranges, config);
            return scanner;
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<D> scanRangesByIndex(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        Optional span = this.startSpan();
        try {
            Scanner scanner = this.getBackingNode().scanRangesByIndex(indexEntryFieldInfo, ranges, config);
            return scanner;
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<IK> scanRangesIndexKeys(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        Optional span = this.startSpan();
        try {
            Scanner scanner = this.getBackingNode().scanRangesIndexKeys(indexEntryFieldInfo, ranges, config);
            return scanner;
        }
        finally {
            span.ifPresent(Scope::close);
        }
    }

    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>, MN extends ManagedNode<PK, D, IK, IE, IF>> MN registerManaged(MN managedNode) {
        return (MN)this.getBackingNode().registerManaged(managedNode);
    }

    default public List<ManagedNode<PK, D, ?, ?, ?>> getManagedNodes() {
        return this.getBackingNode().getManagedNodes();
    }
}

