/*
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.model.field.imp.custom;

import java.util.Date;

import io.datarouter.model.field.BasePrimitiveField;
import io.datarouter.util.bytes.LongByteTool;
import io.datarouter.util.string.StringTool;

public class LongDateField extends BasePrimitiveField<Date,LongDateFieldKey>{

	public LongDateField(LongDateFieldKey key, Date value){
		super(key, value);
	}

	/**
	 * @return the "long" format for persistence.  Note that getValueString() returns the human-readable date
	 */
	@Override
	public String getStringEncodedValue(){
		if(value == null){
			return null;
		}
		return value.getTime() + "";
	}

	@Override
	public Date parseStringEncodedValueButDoNotSet(String str){
		if(StringTool.isEmpty(str) || "null".equals(str)){
			return null;
		}
		return new Date(Long.valueOf(str));
	}

	@Override
	public byte[] getBytes(){
		return value == null ? null : LongByteTool.getUInt63Bytes(value.getTime());
	}

	@Override
	public int numBytesWithSeparator(byte[] bytes, int offset){
		return 8;
	}

	@Override
	public Date fromBytesButDoNotSet(byte[] bytes, int offset){
		return new Date(LongByteTool.fromUInt63Bytes(bytes, offset));
	}

}
