/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.web;

import io.datarouter.instrumentation.metric.MetricLinkBuilder;
import io.datarouter.metric.web.MetricLinkPageFactory;
import io.datarouter.plugin.PluginInjector;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.metriclinks.MetricLinkDto;
import io.datarouter.web.metriclinks.MetricLinkPage;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H2Tag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TdTag;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class MetricLinksHandler
extends BaseHandler {
    @Inject
    private PluginInjector pluginInjector;
    @Inject
    private MetricLinkPageFactory pageFactory;
    @Inject
    private MetricLinkBuilder linkBuilder;

    @BaseHandler.Handler
    public Mav view() {
        List tags = (List)this.pluginInjector.scanInstances(MetricLinkPage.KEY).sort(Comparator.comparing(MetricLinkPage::getHtmlName)).exclude(page -> page.getMetricLinks().isEmpty()).map(this::makeContent).collect(Collectors.toList());
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{TagCreator.each((Collection)tags, item -> TagCreator.div((DomContent[])new DomContent[]{item}))});
        return this.pageFactory.startBuilder(this.request).withTitle("Metric Links").withContent((DomContent)content).withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).buildMav();
    }

    private DivTag makeContent(MetricLinkPage page) {
        H2Tag h2 = (H2Tag)TagCreator.h2((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{page.getHtmlName(), TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fas fa-home")}).withHref("#metric-link-subnav")})}).withId(page.getHtmlId());
        List metricLinks = Scanner.of((Iterable)page.getMetricLinks()).sort(Comparator.comparing(link -> link.name)).list();
        TableTag table = new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)page.getName()).withClass("w-50"), row -> TagCreator.td((String)row.name)).withHtmlColumn((DomContent)TagCreator.th((String)"Exact").withClass("w-25"), row -> {
            if (row.exactMetricName.isEmpty()) {
                return TagCreator.td((String)"");
            }
            return TagCreator.td((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)((MetricLinkDto.LinkDto)row.exactMetricName.get()).display).withHref(this.linkBuilder.exactMetricLink(((MetricLinkDto.LinkDto)row.exactMetricName.get()).metric))).withTarget("_blank")});
        }).withHtmlColumn((DomContent)TagCreator.th((String)"Available").withClass("w-25"), row -> {
            if (row.availableMetricPrefix.isEmpty()) {
                return TagCreator.td((String)"");
            }
            return (TdTag)TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)((MetricLinkDto.LinkDto)row.availableMetricPrefix.get()).display).withHref(this.linkBuilder.availableMetricsLink(((MetricLinkDto.LinkDto)row.availableMetricPrefix.get()).metric))}).attr("target", (Object)"_blank");
        }).withCaption("Total " + metricLinks.size()).build((Collection)metricLinks);
        return (DivTag)TagCreator.div((DomContent[])new DomContent[]{h2, table}).withClass("container my-4");
    }
}

