/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.web;

import io.datarouter.metric.links.MetricNameRegistry;
import io.datarouter.metric.service.ViewMetricNameService;
import io.datarouter.metric.web.MetricLinkPageFactory;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import javax.inject.Inject;

public class AdditionalMetricLinksHandlers {
    private static final String METRIC_LINKS = "Metric Links - ";

    public static class MetricDashboardHandler
    extends BaseHandler {
        @Inject
        private MetricLinkPageFactory pageFactory;
        @Inject
        private ViewMetricNameService service;
        @Inject
        private ServerTypeDetector serverTypeDetector;

        @BaseHandler.Handler(defaultHandler=true)
        public Mav view() {
            String title = "Dashboards";
            DivTag content = this.service.getDashboardsTable();
            if (!this.serverTypeDetector.mightBeProduction()) {
                content = TagCreator.div();
            }
            return this.pageFactory.startBuilder(this.request).withTitle(AdditionalMetricLinksHandlers.METRIC_LINKS + title).withContent((DomContent)content).buildMav();
        }
    }

    public static class MiscMetricLinksHandler
    extends BaseHandler {
        @Inject
        private MetricLinkPageFactory pageFactory;
        @Inject
        private ViewMetricNameService service;

        @BaseHandler.Handler(defaultHandler=true)
        public Mav view() {
            String title = "Misc Metric Links";
            DivTag content = this.service.miscMetricLinksTable();
            return this.pageFactory.startBuilder(this.request).withTitle(AdditionalMetricLinksHandlers.METRIC_LINKS + title).withContent((DomContent)content).buildMav();
        }
    }

    public static class RegisteredMetricNames
    extends BaseHandler {
        @Inject
        private MetricLinkPageFactory pageFactory;
        @Inject
        private ViewMetricNameService service;
        @Inject
        private MetricNameRegistry registry;

        @BaseHandler.Handler(defaultHandler=true)
        public Mav view() {
            String title = "Registered Names";
            return this.pageFactory.startBuilder(this.request).withTitle(AdditionalMetricLinksHandlers.METRIC_LINKS + title).withContent((DomContent)this.service.makeMetricNameTable(title, this.registry.metricNames)).buildMav();
        }
    }
}

