/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.service;

import io.datarouter.instrumentation.metric.MetricLinkBuilder;
import io.datarouter.metric.dto.MetricDashboardDto;
import io.datarouter.metric.dto.MetricName;
import io.datarouter.metric.dto.MiscMetricLinksDto;
import io.datarouter.metric.links.MetricDashboardRegistry;
import io.datarouter.metric.links.MiscMetricsLinksRegistry;
import io.datarouter.metric.types.MetricNameType;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H2Tag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TdTag;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ViewMetricNameService {
    @Inject
    private MetricLinkBuilder linkBuilder;
    @Inject
    private MetricDashboardRegistry dashboardRegistry;
    @Inject
    private MiscMetricsLinksRegistry miscMetricLinksRegistry;

    public DivTag makeMetricNameTable(String header, List<MetricName> rows) {
        if (rows.size() == 0) {
            return TagCreator.div();
        }
        H2Tag h2 = TagCreator.h2((String)header);
        rows.sort(Comparator.comparing(metricName -> metricName.displayName));
        TableTag table = new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Metric Name").withClass("w-50"), row -> TagCreator.td((String)row.displayName)).withHtmlColumn((DomContent)TagCreator.th((String)"Type").withClass("w-25"), row -> TagCreator.td((String)row.nameType.type)).withHtmlColumn((DomContent)TagCreator.th((String)"").withClass("w-25"), this::getMetricNameLink).withCaption("Total " + rows.size()).build(rows);
        return (DivTag)TagCreator.div((DomContent[])new DomContent[]{h2, table}).withClass("container my-4");
    }

    private TdTag getMetricNameLink(MetricName metricName) {
        String link = metricName.nameType == MetricNameType.AVAILABLE ? this.linkBuilder.availableMetricsLink(metricName.getNameOrPrefix()) : this.linkBuilder.exactMetricLink(metricName.getNameOrPrefix());
        return TagCreator.td((DomContent[])new DomContent[]{((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fa fa-link")}).withClass("btn btn-link w-100 py-0")).withHref(link)).withTarget("_blank")});
    }

    public DivTag getDashboardsTable() {
        List<MetricDashboardDto> dasboards = this.dashboardRegistry.dashboards;
        if (dasboards.size() == 0) {
            return TagCreator.div();
        }
        H2Tag h2 = TagCreator.h2((String)"Metric Dashboards");
        dasboards.sort(Comparator.comparing(metricName -> metricName.displayName));
        TableTag table = new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Dashboard Name").withClass("w-50"), row -> TagCreator.td((String)row.displayName)).withHtmlColumn((DomContent)TagCreator.th((String)"").withClass("w-25"), this::getDashboardLink).build(dasboards);
        return (DivTag)TagCreator.div((DomContent[])new DomContent[]{h2, table}).withClass("container my-4");
    }

    private TdTag getDashboardLink(MetricDashboardDto dashboard) {
        String link = this.linkBuilder.dashboardLink(dashboard.id);
        return TagCreator.td((DomContent[])new DomContent[]{((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fa fa-link")}).withClass("btn btn-link w-100 py-0")).withHref(link)).withTarget("_blank")});
    }

    public DivTag miscMetricLinksTable() {
        List<MiscMetricLinksDto> links = this.miscMetricLinksRegistry.miscMetricLinks;
        if (links.size() == 0) {
            return TagCreator.div();
        }
        H2Tag h2 = TagCreator.h2((String)"Misc Metric Links");
        links.sort(Comparator.comparing(dto -> dto.display));
        TableTag table = new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withHtmlColumn((DomContent)TagCreator.th((String)"Metric Name").withClass("w-50"), row -> TagCreator.td((String)row.display)).withHtmlColumn((DomContent)TagCreator.th((String)"").withClass("w-25"), row -> TagCreator.td((DomContent[])new DomContent[]{((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fa fa-link")}).withClass("btn btn-link w-100 py-0")).withHref(row.link)).withTarget("_blank")})).build(links);
        return (DivTag)TagCreator.div((DomContent[])new DomContent[]{h2, table}).withClass("container my-4");
    }
}

