/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.gauge;

import io.datarouter.instrumentation.gauge.GaugeBatchDto;
import io.datarouter.instrumentation.gauge.GaugePublisher;
import io.datarouter.instrumentation.response.PublishingResponseDto;
import io.datarouter.metric.config.DatarouterGaugeSettingRoot;
import io.datarouter.metric.dto.GaugeBinaryDto;
import io.datarouter.metric.gauge.GaugeDirectoryDao;
import io.datarouter.metric.gauge.GaugeQueueDao;
import io.datarouter.util.Ulid;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GaugePublisherService
implements GaugePublisher {
    private static final Logger logger = LoggerFactory.getLogger(GaugePublisherService.class);
    private final GaugeDirectoryDao gaugeDirectoryDao;
    private final GaugeQueueDao gaugeQueueDao;
    private final DatarouterGaugeSettingRoot gaugeSettings;

    @Inject
    public GaugePublisherService(GaugeDirectoryDao gaugeDirectoryDao, GaugeQueueDao gaugeQueueDao, DatarouterGaugeSettingRoot gaugeSettings) {
        this.gaugeDirectoryDao = gaugeDirectoryDao;
        this.gaugeQueueDao = gaugeQueueDao;
        this.gaugeSettings = gaugeSettings;
    }

    public PublishingResponseDto publish(GaugeBatchDto gaugeBatchDto) {
        if (((Boolean)this.gaugeSettings.saveToQueueInsteadOfDirectory.get()).booleanValue()) {
            List<GaugeBinaryDto> dtos = GaugeBinaryDto.createSizedDtos(gaugeBatchDto, 100);
            logger.info("writing size={} blobs", (Object)dtos.size());
            this.gaugeQueueDao.combineAndPut(dtos);
            return PublishingResponseDto.SUCCESS;
        }
        GaugeBinaryDto dto = GaugeBinaryDto.createSizedDtos(gaugeBatchDto, gaugeBatchDto.batch.size()).get(0);
        Ulid ulid = new Ulid();
        logger.info("writing key={}", (Object)ulid);
        this.gaugeDirectoryDao.write(dto, ulid);
        return PublishingResponseDto.SUCCESS;
    }
}

