/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.dto;

import io.datarouter.instrumentation.metric.MetricType;
import io.datarouter.metric.types.MetricNameType;
import io.datarouter.pathnode.PathNode;
import java.util.Objects;

public class MetricName {
    public final String displayName;
    private final String nameOrPrefix;
    public final MetricNameType nameType;
    public final MetricType metricType;

    private MetricName(String displayName, PathNode nameOrPrefix, MetricNameType nameType, MetricType metricType) {
        this(displayName, nameOrPrefix.join("", " ", ""), nameType, metricType);
    }

    private MetricName(String displayName, String nameOrPrefix, MetricNameType nameType, MetricType metricType) {
        this.displayName = displayName;
        this.nameOrPrefix = nameOrPrefix;
        this.nameType = nameType;
        this.metricType = metricType;
    }

    public String getNameOrPrefix() {
        if (this.nameType == MetricNameType.AVAILABLE) {
            return String.valueOf(this.nameOrPrefix) + ".*";
        }
        return this.nameOrPrefix;
    }

    public static MetricName exactMetric(String displayName, String metricName, MetricType metricType) {
        Objects.requireNonNull(metricType);
        return new MetricName(displayName, metricName, MetricNameType.EXACT, metricType);
    }

    public static MetricName exactMetric(String displayName, PathNode metricName, MetricType metricType) {
        Objects.requireNonNull(metricType);
        return new MetricName(displayName, metricName, MetricNameType.EXACT, metricType);
    }

    public static MetricName availableMetric(String displayName, String prefix) {
        return new MetricName(displayName, prefix, MetricNameType.AVAILABLE, null);
    }

    public static MetricName availableMetric(String displayName, PathNode prefix) {
        return new MetricName(displayName, prefix, MetricNameType.AVAILABLE, null);
    }
}

