/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.dto;

import io.datarouter.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.binarydto.dto.BinaryDto;
import io.datarouter.binarydto.dto.BinaryDtoField;
import io.datarouter.instrumentation.gauge.GaugeBatchDto;
import io.datarouter.instrumentation.gauge.GaugeDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.Require;
import java.util.Collection;
import java.util.List;

public class GaugeBinaryDto
extends BinaryDto<GaugeBinaryDto> {
    @BinaryDtoField(index=0)
    public final String serviceName;
    @BinaryDtoField(index=1)
    public final String serverName;
    @BinaryDtoField(index=2)
    public final List<GaugeItemBinaryDto> items;
    @BinaryDtoField(index=3)
    public final String apiKey;

    private GaugeBinaryDto(String serviceName, String serverName, List<GaugeItemBinaryDto> items) {
        this.serviceName = Require.notBlank((String)serviceName);
        this.serverName = Require.notBlank((String)serverName);
        this.items = items;
        this.apiKey = null;
    }

    public List<GaugeDto> toGaugeDtos() {
        return Scanner.of(this.items).map(item -> new GaugeDto(item.name, this.serviceName, this.serverName, item.ulid, item.value)).list();
    }

    public static List<GaugeBinaryDto> createSizedDtos(GaugeBatchDto gaugeBatchDto, int itemsPerDto) {
        Require.notNull((Object)gaugeBatchDto);
        Require.notEmpty((Collection)gaugeBatchDto.batch);
        return Scanner.of((Iterable)gaugeBatchDto.batch).map(GaugeItemBinaryDto::new).batch(itemsPerDto).map(items -> new GaugeBinaryDto(((GaugeDto)gaugeBatchDto.batch.get((int)0)).serviceName, ((GaugeDto)gaugeBatchDto.batch.get((int)0)).serverName, (List<GaugeItemBinaryDto>)items)).list();
    }

    public static GaugeBinaryDto decode(byte[] bytes) {
        return (GaugeBinaryDto)BinaryDtoIndexedCodec.of(GaugeBinaryDto.class).decode(bytes);
    }

    public static class GaugeItemBinaryDto
    extends BinaryDto<GaugeItemBinaryDto> {
        @BinaryDtoField(index=0)
        public final String name;
        @BinaryDtoField(index=1)
        public final String ulid;
        @BinaryDtoField(index=2)
        public final Long value;

        public GaugeItemBinaryDto(String name, String ulid, Long value) {
            this.name = Require.notBlank((String)name);
            this.ulid = Require.notBlank((String)ulid);
            this.value = (Long)Require.notNull((Object)value);
        }

        public GaugeItemBinaryDto(GaugeDto gaugeDto) {
            this(gaugeDto.name, gaugeDto.ulid, gaugeDto.value);
        }
    }
}

