/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.counter;

import io.datarouter.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.bytes.Codec;
import io.datarouter.conveyor.queue.BlobQueueConsumer;
import io.datarouter.metric.counter.CountBinaryDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.QueueNodeFactory;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.virtualnode.redundant.RedundantBlobQueueStorageNode;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CountQueueDao
extends BaseDao {
    private final BlobQueueStorage.BlobQueueStorageNode<CountBinaryDto> node;

    @Inject
    public CountQueueDao(Datarouter datarouter, DatarouterCountQueueDaoParams params, QueueNodeFactory queueNodeFactory) {
        super(datarouter);
        this.node = (BlobQueueStorage.BlobQueueStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            BlobQueueStorage.BlobQueueStorageNode node = queueNodeFactory.createBlobQueue(clientId, "CountBinaryDto", (Codec)BinaryDtoIndexedCodec.of(CountBinaryDto.class)).withNamespace("shared").withTag(Tag.DATAROUTER).withAgeMonitoring(false).build();
            return node;
        }).listTo(RedundantBlobQueueStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    public void combineAndPut(List<CountBinaryDto> dtos) {
        Scanner.of(dtos).then(arg_0 -> this.node.combineAndPut(arg_0));
    }

    public BlobQueueConsumer<CountBinaryDto> getBlobQueueConsumer() {
        return new BlobQueueConsumer(this.node);
    }

    public static class DatarouterCountQueueDaoParams
    extends BaseRedundantDaoParams {
        public DatarouterCountQueueDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

