/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.counter;

import io.datarouter.instrumentation.response.PublishingResponseDto;
import io.datarouter.metric.config.DatarouterCountSettingRoot;
import io.datarouter.metric.counter.CountBinaryDto;
import io.datarouter.metric.counter.CountDirectoryDao;
import io.datarouter.metric.counter.CountQueueDao;
import io.datarouter.metric.counter.collection.CountPublisher;
import io.datarouter.storage.config.properties.ServerName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.util.Ulid;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CountPublisherService
implements CountPublisher {
    private static final Logger logger = LoggerFactory.getLogger(CountPublisherService.class);
    private final CountDirectoryDao countDirectoryDao;
    private final CountQueueDao countQueueDao;
    private final DatarouterCountSettingRoot countSettings;
    private final ServiceName serviceName;
    private final ServerName serverName;

    @Inject
    public CountPublisherService(CountDirectoryDao countDirectoryDao, CountQueueDao countQueueDao, DatarouterCountSettingRoot countSettings, ServiceName serviceName, ServerName serverName) {
        this.countDirectoryDao = countDirectoryDao;
        this.countQueueDao = countQueueDao;
        this.countSettings = countSettings;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    @Override
    public PublishingResponseDto publish(Map<Long, Map<String, Long>> counts) {
        boolean isQueue = (Boolean)this.countSettings.saveCountsToQueueDaoInsteadOfDirectoryDao.get();
        String ulid = new Ulid().value();
        List<CountBinaryDto> dtos = CountBinaryDto.createSizedDtos(ulid, this.serviceName.get(), this.serverName.get(), counts, isQueue ? 100 : Integer.MAX_VALUE);
        logger.info("writing size={} CountBinaryDtos with key={} to {}", new Object[]{dtos.size(), ulid, isQueue ? "queue" : "directory"});
        if (isQueue) {
            this.countQueueDao.combineAndPut(dtos);
        } else {
            this.countDirectoryDao.write(dtos.get(0), ulid);
        }
        return PublishingResponseDto.SUCCESS;
    }
}

