/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.counter;

import io.datarouter.metric.counter.CountBinaryDto;
import io.datarouter.metric.counter.CountDirectorySupplier;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CountDirectoryDao {
    @Inject
    private CountDirectorySupplier directory;

    public CountBinaryDto read(String filename) {
        return CountBinaryDto.decode(this.directory.getCountsBinaryDtoDirectory().read(PathbeanKey.of((String)filename)));
    }

    public void write(CountBinaryDto dto, String ulid) {
        PathbeanKey key = PathbeanKey.of((String)ulid);
        this.directory.getCountsBinaryDtoDirectory().write(key, dto.encodeIndexed());
    }

    public Scanner<String> scanKeysAllowUnsorted() {
        return this.directory.getCountsBinaryDtoDirectory().scanKeys(Subpath.empty(), new Config().setAllowUnsortedScan(Boolean.valueOf(true))).map(PathbeanKey::getPathAndFile);
    }

    public void delete(String filename) {
        this.directory.getCountsBinaryDtoDirectory().delete(PathbeanKey.of((String)filename));
    }

    public void deleteAll() {
        this.directory.getCountsBinaryDtoDirectory().deleteAll(Subpath.empty());
    }
}

