/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.metric.config;

import io.datarouter.instrumentation.gauge.GaugePublisher;
import io.datarouter.instrumentation.metric.MetricLinkBuilder;
import io.datarouter.metric.config.DatarouterCountSettingRoot;
import io.datarouter.metric.config.DatarouterGaugeSettingRoot;
import io.datarouter.metric.config.DatarouterMetricRouteSet;
import io.datarouter.metric.config.MetricLinksNavBarItem;
import io.datarouter.metric.counter.CountDirectorySupplier;
import io.datarouter.metric.counter.CountQueueDao;
import io.datarouter.metric.counter.CountersAppListener;
import io.datarouter.metric.counter.collection.CountPublisher;
import io.datarouter.metric.counter.conveyor.CountConveyors;
import io.datarouter.metric.dto.MetricDashboardDto;
import io.datarouter.metric.dto.MetricName;
import io.datarouter.metric.dto.MiscMetricLinksDto;
import io.datarouter.metric.gauge.DatabeanGauges;
import io.datarouter.metric.gauge.GaugeDirectorySupplier;
import io.datarouter.metric.gauge.GaugeQueueDao;
import io.datarouter.metric.gauge.conveyor.GaugeConveyors;
import io.datarouter.metric.links.MetricDashboardRegistry;
import io.datarouter.metric.links.MetricNameRegistry;
import io.datarouter.metric.links.MiscMetricsLinksRegistry;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.storage.metric.Gauges;
import io.datarouter.web.config.BaseWebPlugin;
import io.datarouter.web.listener.ComputedPropertiesAppListener;
import java.util.ArrayList;
import java.util.List;

public class DatarouterMetricsPlugin
extends BaseWebPlugin {
    private final Class<? extends CountPublisher> countPublisher;
    private final Class<? extends CountDirectorySupplier> countDirectorySupplier;
    private final Class<? extends GaugePublisher> gaugePublisher;
    private final Class<? extends GaugeDirectorySupplier> gaugeDirectorySupplier;
    private final Class<? extends MetricLinkBuilder> metricLinkBuilder;
    private final List<MetricName> metricNames;
    private final List<MetricDashboardDto> dashboards;
    private final List<MiscMetricLinksDto> miscMetricLinks;

    private DatarouterMetricsPlugin(DatarouterMetricsDaosModule daosModuleBuilder, Class<? extends CountPublisher> countPublisher, Class<? extends CountDirectorySupplier> countDirectorySupplier, Class<? extends GaugePublisher> gaugePublisher, Class<? extends GaugeDirectorySupplier> gaugeDirectorySupplier, Class<? extends MetricLinkBuilder> metricLinkBuilder, boolean enableCountPublishing, boolean enableGaugePublishing, List<MetricName> metricNames, List<MetricDashboardDto> dashboards, List<MiscMetricLinksDto> miscMetricLinks) {
        this.countPublisher = countPublisher;
        this.countDirectorySupplier = countDirectorySupplier;
        this.gaugePublisher = gaugePublisher;
        this.gaugeDirectorySupplier = gaugeDirectorySupplier;
        this.metricLinkBuilder = metricLinkBuilder;
        this.metricNames = metricNames;
        this.dashboards = dashboards;
        this.miscMetricLinks = miscMetricLinks;
        if (enableCountPublishing) {
            this.addAppListenerOrdered(CountersAppListener.class, ComputedPropertiesAppListener.class);
            this.addAppListener(CountConveyors.class);
            this.addSettingRoot(DatarouterCountSettingRoot.class);
        }
        if (enableGaugePublishing) {
            this.addAppListener(GaugeConveyors.class);
            this.addSettingRoot(DatarouterGaugeSettingRoot.class);
        }
        if (enableCountPublishing || enableGaugePublishing) {
            this.addDynamicNavBarItem(MetricLinksNavBarItem.class);
        }
        this.addRouteSet(DatarouterMetricRouteSet.class);
        this.setDaosModule(daosModuleBuilder);
        this.addDatarouterGithubDocLink("datarouter-metric");
    }

    public void configure() {
        this.bind(CountPublisher.class).to(this.countPublisher);
        this.bind(CountDirectorySupplier.class).to(this.countDirectorySupplier);
        this.bind(GaugePublisher.class).to(this.gaugePublisher);
        this.bind(GaugeDirectorySupplier.class).to(this.gaugeDirectorySupplier);
        this.bindActual(Gauges.class, DatabeanGauges.class);
        this.bind(MetricNameRegistry.class).toInstance((Object)new MetricNameRegistry(this.metricNames));
        this.bind(MetricDashboardRegistry.class).toInstance((Object)new MetricDashboardRegistry(this.dashboards));
        this.bind(MiscMetricsLinksRegistry.class).toInstance((Object)new MiscMetricsLinksRegistry(this.miscMetricLinks));
        this.bind(MetricLinkBuilder.class).to(this.metricLinkBuilder);
    }

    public static class DatarouterMetricsDaosModule
    extends DaosModuleBuilder {
        private final List<ClientId> metricBlobQueueClientId;
        private final boolean enableCountPublishing;
        private final boolean enableGaugePublishing;

        public DatarouterMetricsDaosModule(List<ClientId> metricBlobQueueClientId, boolean enableCountPublishing, boolean enableGaugePublishing) {
            this.metricBlobQueueClientId = metricBlobQueueClientId;
            this.enableCountPublishing = enableCountPublishing;
            this.enableGaugePublishing = enableGaugePublishing;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            ArrayList<Class<? extends Dao>> daos = new ArrayList<Class<? extends Dao>>();
            if (this.enableCountPublishing) {
                daos.add(CountQueueDao.class);
            }
            if (this.enableGaugePublishing) {
                daos.add(GaugeQueueDao.class);
            }
            return daos;
        }

        public void configure() {
            if (this.enableCountPublishing) {
                this.bind(CountQueueDao.DatarouterCountQueueDaoParams.class).toInstance((Object)new CountQueueDao.DatarouterCountQueueDaoParams(this.metricBlobQueueClientId));
            }
            if (this.enableGaugePublishing) {
                this.bind(GaugeQueueDao.GaugeQueueDaoParams.class).toInstance((Object)new GaugeQueueDao.GaugeQueueDaoParams(this.metricBlobQueueClientId));
            }
        }
    }

    public static class DatarouterMetricsPluginBuilder {
        private final List<ClientId> metricQueueClientId;
        private final List<MetricName> metricNames;
        private final List<MetricDashboardDto> dashboards;
        private final List<MiscMetricLinksDto> miscMetricLinks;
        private Class<? extends CountPublisher> countPublisher = CountPublisher.NoOpCountPublisher.class;
        private Class<? extends CountDirectorySupplier> countDirectorySupplier = CountDirectorySupplier.NoOpCountDirectorySupplier.class;
        private Class<? extends GaugePublisher> gaugePublisher = GaugePublisher.NoOpGaugePublisher.class;
        private Class<? extends GaugeDirectorySupplier> gaugeDirectorySupplier = GaugeDirectorySupplier.NoOpGaugeDirectorySupplier.class;
        private Class<? extends MetricLinkBuilder> metricLinkBuilder = MetricLinkBuilder.NoOpMetricLinkBuilder.class;
        private DatarouterMetricsDaosModule daosModule;

        public DatarouterMetricsPluginBuilder(List<ClientId> metricQueueClientId, Class<? extends CountPublisher> countPublisher, Class<? extends CountDirectorySupplier> countDirectorySupplier, Class<? extends GaugePublisher> gaugePublisher, Class<? extends GaugeDirectorySupplier> gaugeDirectorySupplier) {
            this.metricQueueClientId = metricQueueClientId;
            this.countPublisher = countPublisher;
            this.countDirectorySupplier = countDirectorySupplier;
            this.gaugePublisher = gaugePublisher;
            this.gaugeDirectorySupplier = gaugeDirectorySupplier;
            this.metricNames = new ArrayList<MetricName>();
            this.dashboards = new ArrayList<MetricDashboardDto>();
            this.miscMetricLinks = new ArrayList<MiscMetricLinksDto>();
        }

        public DatarouterMetricsPluginBuilder withDaosModule(DatarouterMetricsDaosModule daosModule) {
            this.daosModule = daosModule;
            return this;
        }

        public DatarouterMetricsPluginBuilder withCountPublisher(Class<? extends CountPublisher> countPublisher) {
            this.countPublisher = countPublisher;
            return this;
        }

        public DatarouterMetricsPluginBuilder withCountDirectorySupplier(Class<? extends CountDirectorySupplier> countDirectorySupplier) {
            this.countDirectorySupplier = countDirectorySupplier;
            return this;
        }

        public DatarouterMetricsPluginBuilder withGaugePublisher(Class<? extends GaugePublisher> gaugePublisher) {
            this.gaugePublisher = gaugePublisher;
            return this;
        }

        public DatarouterMetricsPluginBuilder withGaugeDirectorySupplier(Class<? extends GaugeDirectorySupplier> gaugeDirectorySupplier) {
            this.gaugeDirectorySupplier = gaugeDirectorySupplier;
            return this;
        }

        public DatarouterMetricsPluginBuilder addMetricName(MetricName name) {
            this.metricNames.add(name);
            return this;
        }

        public DatarouterMetricsPluginBuilder addMetricNames(List<MetricName> names) {
            this.metricNames.addAll(names);
            return this;
        }

        public DatarouterMetricsPluginBuilder addDashboard(MetricDashboardDto dashboard) {
            this.dashboards.add(dashboard);
            return this;
        }

        public DatarouterMetricsPluginBuilder addDashboards(List<MetricDashboardDto> dashboards) {
            this.dashboards.addAll(dashboards);
            return this;
        }

        public DatarouterMetricsPluginBuilder addMiscMetricLink(MiscMetricLinksDto miscMetricLink) {
            this.miscMetricLinks.add(miscMetricLink);
            return this;
        }

        public DatarouterMetricsPluginBuilder addMiscMetricLinks(List<MiscMetricLinksDto> miscMetricLink) {
            this.miscMetricLinks.addAll(miscMetricLink);
            return this;
        }

        public DatarouterMetricsPluginBuilder withMetricLinkBuilder(Class<? extends MetricLinkBuilder> metricLinkBuilder) {
            this.metricLinkBuilder = metricLinkBuilder;
            return this;
        }

        public DatarouterMetricsPlugin build() {
            boolean enableCountPublishing = !this.countPublisher.isInstance(CountPublisher.NoOpCountPublisher.class);
            boolean enableGaugePublishing = !this.gaugePublisher.isInstance(GaugePublisher.NoOpGaugePublisher.class);
            return new DatarouterMetricsPlugin(this.daosModule == null ? new DatarouterMetricsDaosModule(this.metricQueueClientId, enableCountPublishing, enableGaugePublishing) : this.daosModule, this.countPublisher, this.countDirectorySupplier, this.gaugePublisher, this.gaugeDirectorySupplier, this.metricLinkBuilder, enableCountPublishing, enableGaugePublishing, this.metricNames, this.dashboards, this.miscMetricLinks);
        }
    }
}

