/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter;

import io.datarouter.instrumentation.count.Counters;
import io.datarouter.util.DateTool;
import io.datarouter.util.tuple.Pair;
import io.datarouter.web.util.http.RequestTool;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NamedRateLimiter {
    private static final Logger logger = LoggerFactory.getLogger(NamedRateLimiter.class);
    private static final String COUNTER_PREFIX = "RateLimiter ";
    private final String name;

    public NamedRateLimiter(String name) {
        this.name = name;
    }

    public final boolean peek(String key) {
        return (Boolean)this.internalAllow(this.makeKey(key), false).getLeft();
    }

    public final boolean allowed() {
        return this.allowed("");
    }

    public final boolean allowed(String dynamicKey) {
        Pair<Boolean, Calendar> allowed = this.internalAllow(this.makeKey(dynamicKey), true);
        if (((Boolean)allowed.getLeft()).booleanValue()) {
            Counters.inc((String)(COUNTER_PREFIX + this.name + " allowed"));
        } else {
            Counters.inc((String)(COUNTER_PREFIX + this.name + " limit reached"));
        }
        return (Boolean)allowed.getLeft();
    }

    public final boolean allowedForIp(HttpServletRequest request) {
        return this.allowedForIp("", request);
    }

    public final boolean allowedForIp(String dynamicKey, HttpServletRequest request) {
        String ip = RequestTool.getIpAddress((HttpServletRequest)request);
        Pair<Boolean, Calendar> allowed = this.internalAllow(this.makeKey(dynamicKey, ip), true);
        if (((Boolean)allowed.getLeft()).booleanValue()) {
            Counters.inc((String)("RateLimiter ip " + this.name + " allowed"));
        } else {
            logger.info("RateLimiter=" + this.name + " limit reached for ip=" + RequestTool.getIpAddress((HttpServletRequest)request) + ", next allowed " + DateTool.getYyyyMmDdHhMmSsMmmWithPunctuationNoSpaces((Long)((Calendar)allowed.getRight()).getTimeInMillis()));
            Counters.inc((String)("RateLimiter ip " + this.name + " limit reached"));
        }
        return (Boolean)allowed.getLeft();
    }

    private String makeKey(String ... keyFields) {
        return String.join((CharSequence)"_", keyFields);
    }

    protected abstract Pair<Boolean, Calendar> internalAllow(String var1, boolean var2);
}

