/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter;

import io.datarouter.client.memcached.ratelimiter.BaseTallyDao;
import io.datarouter.ratelimiter.BaseNamedMemcachedRateLimiter;
import io.datarouter.util.Require;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NamedMemcachedRateLimiterFactory {
    @Inject
    private BaseTallyDao tallyDao;

    public class NamedMemcachedRateLimiter
    extends BaseNamedMemcachedRateLimiter {
        public NamedMemcachedRateLimiter(String name, long maxAvgRequests, long maxSpikeRequests, int numIntervals, int bucketTimeInterval, TimeUnit unit) {
            super(name, maxAvgRequests, maxSpikeRequests, numIntervals, bucketTimeInterval, unit);
        }

        @Override
        protected Long increment(String key) {
            return NamedMemcachedRateLimiterFactory.this.tallyDao.incrementAndGetCount(key, 1, this.expiration, Duration.ofMillis(200L));
        }

        @Override
        protected Map<String, Long> readCounts(List<String> keys) {
            return NamedMemcachedRateLimiterFactory.this.tallyDao.getMultiTallyCount(keys, this.expiration, Duration.ofMillis(200L));
        }
    }

    public class NamedMemcachedRateLimiterBuilder {
        private final String name;
        private Long maxAvgRequests;
        private Long maxSpikeRequests;
        private Integer numIntervals;
        private Integer bucketTimeInterval;
        private TimeUnit unit;

        public NamedMemcachedRateLimiterBuilder(String name) {
            this.name = name;
        }

        public NamedMemcachedRateLimiterBuilder maxAvgRequests(long maxAvgRequests) {
            this.maxAvgRequests = maxAvgRequests;
            return this;
        }

        public NamedMemcachedRateLimiterBuilder maxSpikeRequests(long maxSpikeRequests) {
            this.maxSpikeRequests = maxSpikeRequests;
            return this;
        }

        public NamedMemcachedRateLimiterBuilder numIntervals(int numIntervals) {
            this.numIntervals = numIntervals;
            return this;
        }

        public NamedMemcachedRateLimiterBuilder bucketTimeInterval(int bucketTimeInterval, TimeUnit unit) {
            this.bucketTimeInterval = bucketTimeInterval;
            this.unit = unit;
            return this;
        }

        public NamedMemcachedRateLimiter build() {
            List<Object> arguments = Arrays.asList(new Object[]{this.name, this.maxAvgRequests, this.maxSpikeRequests, this.numIntervals, this.bucketTimeInterval, this.unit});
            Require.isFalse((boolean)arguments.contains(null));
            return new NamedMemcachedRateLimiter(this.name, this.maxAvgRequests, this.maxSpikeRequests, this.numIntervals, this.bucketTimeInterval, this.unit);
        }
    }
}

