/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter;

import io.datarouter.instrumentation.count.Counters;
import io.datarouter.ratelimiter.NamedRateLimiter;
import io.datarouter.util.iterable.IterableTool;
import io.datarouter.util.tuple.Pair;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class BaseNamedMemcachedRateLimiter
extends NamedRateLimiter {
    private static final String HIT_COUNTER_NAME = "rate limit hit";
    private final long maxAvgRequests;
    private final long maxSpikeRequests;
    private final int numIntervals;
    private final int bucketTimeInterval;
    private final TimeUnit timeunit;
    private final int bucketIntervalMs;
    protected final Duration expiration;

    public BaseNamedMemcachedRateLimiter(String name, long maxAvgRequests, long maxSpikeRequests, int numIntervals, int bucketTimeInterval, TimeUnit unit) {
        super(name);
        this.maxAvgRequests = maxAvgRequests;
        this.maxSpikeRequests = maxSpikeRequests;
        this.numIntervals = numIntervals;
        this.bucketIntervalMs = Math.toIntExact(unit.toMillis(bucketTimeInterval));
        this.bucketTimeInterval = bucketTimeInterval;
        this.timeunit = unit;
        this.expiration = Duration.ofMillis(this.bucketIntervalMs * (numIntervals + 1));
    }

    protected abstract Long increment(String var1);

    protected abstract Map<String, Long> readCounts(List<String> var1);

    @Override
    protected Pair<Boolean, Calendar> internalAllow(String key, boolean increment) {
        Calendar cal = Calendar.getInstance();
        Map<String, Long> results = this.readCounts(this.buildKeysToRead(key, cal));
        String currentMapKey = this.makeMapKey(key, this.getTimeStr((Calendar)cal.clone()));
        int total = 0;
        for (Map.Entry<String, Long> entry : results.entrySet()) {
            Long numRequests = entry.getValue() == null ? 0L : entry.getValue();
            if (entry.getKey().equals(currentMapKey)) {
                numRequests = numRequests + 1L;
            }
            if (numRequests > this.maxSpikeRequests) {
                Calendar exceededCal = this.getDateFromKey(entry.getKey());
                exceededCal.add(14, this.bucketIntervalMs * (this.numIntervals - 1));
                Counters.inc((String)HIT_COUNTER_NAME);
                return new Pair((Object)false, (Object)exceededCal);
            }
            total = (int)((long)total + numRequests);
        }
        double avgRequests = (double)total / (double)this.numIntervals;
        if (avgRequests > (double)this.maxAvgRequests) {
            List cals = IterableTool.map(results.keySet(), this::getDateFromKey);
            Calendar lastTime = null;
            for (Calendar calendar : cals) {
                if (lastTime != null && !calendar.after(lastTime)) continue;
                lastTime = calendar;
            }
            Objects.requireNonNull(lastTime);
            lastTime.add(14, this.bucketIntervalMs);
            Counters.inc((String)HIT_COUNTER_NAME);
            return new Pair((Object)false, (Object)lastTime);
        }
        if (increment) {
            this.increment(currentMapKey);
        }
        return new Pair((Object)true, null);
    }

    private List<String> buildKeysToRead(String key, Calendar calendar) {
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        while (i < this.numIntervals) {
            Calendar cal = (Calendar)calendar.clone();
            int amount = i * this.bucketIntervalMs;
            cal.add(14, -amount);
            String mapKey = this.makeMapKey(key, this.getTimeStr(cal));
            keys.add(mapKey.toString());
            ++i;
        }
        return keys;
    }

    private String makeMapKey(String key, String time) {
        return String.valueOf(key.replaceAll("!", "%21")) + "!" + time;
    }

    private Pair<String, String> unmakeMapKey(String mapKey) {
        String[] splits = mapKey.split("!");
        return new Pair((Object)splits[0].replaceAll("%21", "!"), (Object)splits[1]);
    }

    protected String getTimeStr(Calendar cal) {
        int calendarField;
        switch (this.timeunit) {
            case DAYS: {
                calendarField = 5;
                break;
            }
            case HOURS: {
                calendarField = 10;
                break;
            }
            case MINUTES: {
                calendarField = 12;
                break;
            }
            case SECONDS: {
                calendarField = 13;
                break;
            }
            default: {
                calendarField = 14;
            }
        }
        BaseNamedMemcachedRateLimiter.setCalendarFieldForBucket(cal, calendarField, this.bucketTimeInterval);
        return this.getDateFormatForTimeUnit().format(cal.getTime());
    }

    private DateFormat getDateFormatForTimeUnit() {
        switch (this.timeunit) {
            case DAYS: {
                return new SimpleDateFormat("yyyyMMdd");
            }
            case HOURS: {
                return new SimpleDateFormat("yyyyMMddHH");
            }
            case MINUTES: {
                return new SimpleDateFormat("yyyyMMddHHmm");
            }
            case SECONDS: {
                return new SimpleDateFormat("yyyyMMddHHmmss");
            }
        }
        return new SimpleDateFormat("yyyyMMddHHmmssSSS");
    }

    private Calendar getDateFromKey(String key) {
        String dateString = (String)this.unmakeMapKey(key).getRight();
        try {
            DateFormat dateFormat = this.getDateFormatForTimeUnit();
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateFormat.parse(dateString));
            return cal;
        }
        catch (ParseException e) {
            throw new IllegalStateException("unparseable key " + key, e);
        }
    }

    private static void setCalendarFieldForBucket(Calendar calendar, int calendarField, int fieldInterval) {
        calendar.set(calendarField, fieldInterval * (calendar.get(calendarField) / fieldInterval));
    }

    public long getMaxAvgRequests() {
        return this.maxAvgRequests;
    }

    public long getMaxSpikeRequests() {
        return this.maxSpikeRequests;
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }
}

