/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.storage.client.ClientOptions;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MemcachedOptions {
    private static final String PREFIX_MEMCACHED = "memcached.";
    protected static final String PROP_numServers = "numServers";
    protected static final String PROP_server = "server";
    @Inject
    private ClientOptions clientOptions;

    public List<InetSocketAddress> getServers(String clientName) {
        return IntStream.range(0, this.getNumServers(clientName)).mapToObj(index -> MemcachedOptions.makeMemcachedKey("server." + index)).map(propertyKey -> this.clientOptions.optInetSocketAddress(clientName, propertyKey)).map(Optional::get).collect(Collectors.toList());
    }

    private Integer getNumServers(String clientName) {
        return this.clientOptions.getRequiredInteger(clientName, MemcachedOptions.makeMemcachedKey(PROP_numServers));
    }

    protected static String makeMemcachedKey(String propertyKey) {
        return PREFIX_MEMCACHED + propertyKey;
    }
}

