/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.ratelimiter;

import io.datarouter.client.memcached.BaseMemcachedClientNodeFactory;
import io.datarouter.client.memcached.node.MemcachedNode;
import io.datarouter.client.memcached.tally.Tally;
import io.datarouter.client.memcached.tally.TallyKey;
import io.datarouter.inject.DatarouterInjector;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.node.NodeParams;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TallyNodeFactory {
    @Inject
    private DatarouterClients datarouterClients;
    @Inject
    private DatarouterInjector injector;

    public MemcachedNode<TallyKey, Tally, Tally.TallyFielder> create(ClientId clientId, int version) {
        return this.create(clientId, version, null);
    }

    public MemcachedNode<TallyKey, Tally, Tally.TallyFielder> create(ClientId clientId, int version, String tableName) {
        ClientType clientType = this.datarouterClients.getClientTypeInstance(clientId);
        Objects.requireNonNull(clientType, "clientType not found for clientName:" + clientId.getName());
        NodeParams params = new NodeParams.NodeParamsBuilder(Tally::new, Tally.TallyFielder::new).withClientId(clientId).withSchemaVersion(Integer.valueOf(version)).withTableName(tableName).build();
        return ((BaseMemcachedClientNodeFactory)((Object)this.injector.getInstance(clientType.getClientNodeFactoryClass()))).createNodeWithoutAdapters(params);
    }
}

