/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.util.PrimaryKeyPercentCodec;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DatarouterMemcachedKey {
    public static final Integer DATAROUTER_VERSION = 3;
    public final String nodeName;
    public final Integer databeanVersion;
    public final PrimaryKey<?> primaryKey;

    public DatarouterMemcachedKey(String nodeName, Integer databeanVersion, PrimaryKey<?> primaryKey) {
        if (nodeName.contains(":")) {
            throw new IllegalArgumentException("nodeName cannot contain \":\"");
        }
        this.nodeName = nodeName;
        this.databeanVersion = databeanVersion;
        this.primaryKey = primaryKey;
    }

    public String getVersionedKeyString() {
        String encodedPk = PrimaryKeyPercentCodec.encode(this.primaryKey);
        return DATAROUTER_VERSION + ":" + this.nodeName + ":" + this.databeanVersion + ":" + encodedPk;
    }

    public static List<String> getVersionedKeyStrings(String nodeName, int version, Collection<? extends PrimaryKey<?>> pks) {
        return pks.stream().filter(Objects::nonNull).map(pk -> new DatarouterMemcachedKey(nodeName, version, (PrimaryKey<?>)pk)).map(DatarouterMemcachedKey::getVersionedKeyString).collect(Collectors.toList());
    }

    public static <PK extends PrimaryKey<PK>> DatarouterMemcachedKey parse(String string, Class<PK> pkClass) {
        StringBuilder current = new StringBuilder();
        String[] parts = new String[3];
        int counter = 0;
        int i = 0;
        while (i < string.length()) {
            char character = string.charAt(i);
            if (character == ':') {
                parts[counter++] = current.toString();
                current = new StringBuilder();
            } else {
                current.append(character);
            }
            ++i;
        }
        if (counter != 3) {
            throw new RuntimeException("incorrect number of parts, counter=" + counter + " input=" + string);
        }
        int databeanVersion = Integer.parseInt(parts[2]);
        PrimaryKey primaryKey = PrimaryKeyPercentCodec.decode(pkClass, (String)current.toString());
        return new DatarouterMemcachedKey(parts[1], databeanVersion, primaryKey);
    }
}

