/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.web;

import io.datarouter.client.memcached.client.MemcachedClientHolder;
import io.datarouter.client.memcached.client.SpyMemcachedClient;
import io.datarouter.client.memcached.client.options.MemcachedOptions;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientType;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.tuple.Pair;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

public class MemcachedWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private MemcachedClientHolder clientHolder;
    @Inject
    private MemcachedOptions memcachedOptions;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, ClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        DivTag content = (DivTag)TagCreator.div((DomContent[])new DomContent[]{this.buildClientPageHeader(clientName), this.buildOverview(clientId), this.buildClientOptionsTable(allClientOptions), this.buildStats(this.getSpyClient(clientId).getStats())}).withClass("container my-3");
        return this.pageFactory.startBuilder(request).withTitle("Datarouter Client - " + this.clientOptions.getClientType(clientId)).withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent((DomContent)content).buildMav();
    }

    protected SpyMemcachedClient getSpyClient(ClientId clientId) {
        return this.clientHolder.get(clientId).getSpyClient();
    }

    protected Pair<Integer, DivTag> getDetails(ClientId clientId) {
        Pair nodeCountByNodeTag = new Pair();
        List socketAddresses = Scanner.of(this.memcachedOptions.getServers(clientId.getName())).map(InetSocketAddress::toString).map(TagCreator::li).list();
        DivTag div = TagCreator.div((DomContent[])new DomContent[]{TagCreator.ul((DomContent[])((DomContent[])socketAddresses.toArray(new ContainerTag[0])))});
        nodeCountByNodeTag.setLeft((Object)socketAddresses.size());
        nodeCountByNodeTag.setRight((Object)div);
        return nodeCountByNodeTag;
    }

    private DivTag buildOverview(ClientId clientId) {
        Pair<Integer, DivTag> listElements = this.getDetails(clientId);
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.p((DomContent[])new DomContent[]{TagCreator.b((String)("Number of nodes: " + listElements.getLeft()))}), TagCreator.h4((String)"Nodes"), (DomContent)listElements.getRight()});
    }

    private DivTag buildStats(Map<SocketAddress, Map<String, String>> statsPerSocketAddress) {
        DivTag allStats = TagCreator.div();
        Scanner.of(statsPerSocketAddress.entrySet()).map(entry -> this.buildSingleNodeStats(((SocketAddress)entry.getKey()).toString(), (Map)entry.getValue())).forEach(arg_0 -> ((DivTag)allStats).with(arg_0));
        return allStats;
    }

    private DivTag buildSingleNodeStats(String socketAddress, Map<String, String> stats) {
        TbodyTag tbody = TagCreator.tbody();
        Scanner.of(stats.entrySet()).sort(Map.Entry.comparingByKey()).map(entry -> TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)((String)entry.getKey())), TagCreator.td((String)MemcachedWebInspector.formatIfNumber((String)entry.getValue()))})).forEach(arg_0 -> ((TbodyTag)tbody).with(arg_0));
        TableTag table = (TableTag)TagCreator.table((DomContent[])new DomContent[]{tbody}).withClass("table table-striped table-hover table-sm");
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)(String.valueOf(socketAddress) + " Node Details")), table});
    }

    private static String formatIfNumber(String value) {
        try {
            return NumberFormatter.addCommas((Number)Double.valueOf(value));
        }
        catch (Exception e) {
            return value;
        }
    }
}

