/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.node;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.InputStreamTool;
import io.datarouter.client.memcached.client.DatarouterMemcachedClient;
import io.datarouter.client.memcached.codec.MemcachedBlobCodec;
import io.datarouter.client.memcached.util.MemcachedExpirationTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.tuple.Pair;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class MemcachedBlobNode
extends BasePhysicalNode<PathbeanKey, Pathbean, Pathbean.PathbeanFielder>
implements BlobStorage.PhysicalBlobStorageNode {
    private static final boolean DEFAULT_IGNORE_EXCEPTION = true;
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(3L);
    private final Subpath rootPath;
    private final MemcachedBlobCodec blobCodec;
    private final Supplier<DatarouterMemcachedClient> lazyClient;

    public MemcachedBlobNode(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> params, ClientType<?, ?> clientType, MemcachedBlobCodec blobCodec, Supplier<DatarouterMemcachedClient> lazyClient) {
        super(params, clientType);
        this.blobCodec = blobCodec;
        this.lazyClient = lazyClient;
        this.rootPath = params.getPath();
    }

    public String getBucket() {
        throw new UnsupportedOperationException();
    }

    public Subpath getRootPath() {
        return this.rootPath;
    }

    public boolean exists(PathbeanKey key, Config config) {
        return this.scanMultiKeysInternal(List.of(key)).hasAny();
    }

    public Optional<Long> length(PathbeanKey key, Config config) {
        return this.scanMultiInternal(List.of(key)).map(Pair::getRight).map(bytes -> ((byte[])bytes).length).map(Integer::longValue).findFirst();
    }

    public byte[] read(PathbeanKey key, Config config) {
        return this.scanMultiInternal(List.of(key)).findFirst().map(Pair::getRight).orElse(null);
    }

    public Map<PathbeanKey, byte[]> read(List<PathbeanKey> keys, Config config) {
        return this.scanMultiInternal(keys).toMap(Pair::getLeft, Pair::getRight);
    }

    public byte[] read(PathbeanKey key, long offset, int length, Config config) {
        int intOffset = (int)offset;
        return this.scanMultiInternal(List.of(key)).findFirst().map(Pair::getRight).map(bytes -> Arrays.copyOfRange(bytes, intOffset, intOffset + length)).orElse(null);
    }

    public Scanner<List<PathbeanKey>> scanKeysPaged(Subpath subpath, Config config) {
        throw new UnsupportedOperationException();
    }

    public Scanner<List<Pathbean>> scanPaged(Subpath subpath, Config config) {
        throw new UnsupportedOperationException();
    }

    public void write(PathbeanKey key, byte[] value, Config config) {
        this.lazyClient.get().set(this.getName(), this.blobCodec.encodeKey(key), MemcachedExpirationTool.getExpirationSeconds(config), value);
    }

    public void write(PathbeanKey key, Scanner<byte[]> chunks, Config config) {
        byte[] value = (byte[])chunks.listTo(ByteTool::concat);
        this.write(key, value, config);
    }

    public void write(PathbeanKey key, InputStream inputStream, Config config) {
        byte[] value = InputStreamTool.toArray((InputStream)inputStream);
        this.write(key, value, config);
    }

    public void delete(PathbeanKey key, Config config) {
        this.lazyClient.get().delete(this.getName(), this.blobCodec.encodeKey(key), Duration.ofSeconds(3L));
    }

    public void deleteAll(Subpath subpath, Config config) {
        throw new UnsupportedOperationException();
    }

    private Scanner<PathbeanKey> scanMultiKeysInternal(Collection<PathbeanKey> keys) {
        return ((Scanner)Scanner.of(keys).map(this.blobCodec::encodeKey).listTo(memcachedStringKeys -> this.lazyClient.get().scanMultiBytes(this.getName(), (Collection<String>)memcachedStringKeys, DEFAULT_TIMEOUT.toMillis(), true))).map(Pair::getLeft).map(this.blobCodec::decodeKey);
    }

    private Scanner<Pair<PathbeanKey, byte[]>> scanMultiInternal(Collection<PathbeanKey> keys) {
        return ((Scanner)Scanner.of(keys).map(this.blobCodec::encodeKey).listTo(memcachedStringKeys -> this.lazyClient.get().scanMultiBytes(this.getName(), (Collection<String>)memcachedStringKeys, DEFAULT_TIMEOUT.toMillis(), true))).map(this.blobCodec::decodeResult);
    }
}

