/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.codec;

import io.datarouter.bytes.codec.stringcodec.TerminatedStringCodec;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.tuple.Pair;
import java.util.Base64;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedTallyCodec {
    private static final Logger logger = LoggerFactory.getLogger(MemcachedTallyCodec.class);
    public static final String CODEC_VERSION = "1";
    private final String clientTypeName;
    private final Subpath nodeSubpath;
    private final int clientMaxKeyLength;
    private final int nodeSubpathLength;

    public MemcachedTallyCodec(String clientTypeName, Subpath nodePath, int clientMaxKeyLength) {
        this.clientTypeName = clientTypeName;
        this.nodeSubpath = nodePath;
        this.clientMaxKeyLength = clientMaxKeyLength;
        this.nodeSubpathLength = nodePath.toString().length();
    }

    public Optional<String> encodeKeyIfValid(String id) {
        String encodedKey = MemcachedTallyCodec.encodeTallyId(this.nodeSubpath, id);
        if (encodedKey.length() > this.clientMaxKeyLength) {
            logger.warn("tally id too long for {} tallyId={} tallyIdLength={} nodePath={} nodePathLength={} encodedKey={} encodedKeyLength={} maxEncodedKeyLength={}", new Object[]{this.clientTypeName, id, id.length(), this.nodeSubpath, this.nodeSubpathLength, encodedKey, encodedKey.length(), this.clientMaxKeyLength});
            return Optional.empty();
        }
        return Optional.of(encodedKey);
    }

    public Pair<String, Long> decodeResult(Pair<String, String> result) {
        String stringPk = MemcachedTallyCodec.decodeTallyId(this.nodeSubpathLength, (String)result.getLeft());
        String stringValue = (String)result.getRight();
        long longValue = Long.parseLong(stringValue);
        return new Pair((Object)stringPk, (Object)longValue);
    }

    private static String encodeTallyId(Subpath subpath, String tallyId) {
        byte[] tallyIdBytes = TerminatedStringCodec.UTF_8.encode(tallyId);
        String encodedTallyId = Base64.getUrlEncoder().encodeToString(tallyIdBytes);
        return subpath + encodedTallyId;
    }

    private static String decodeTallyId(int subpathLength, String fullMemcachedKey) {
        String encodedTallyId = fullMemcachedKey.substring(subpathLength);
        byte[] tallyIdBytes = Base64.getUrlDecoder().decode(encodedTallyId);
        return (String)TerminatedStringCodec.UTF_8.decode((byte[])tallyIdBytes).value;
    }
}

