/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client.options;

import io.datarouter.client.memcached.client.options.MemcachedOptions;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsBuilder;
import java.util.List;
import java.util.Properties;

public class MemcachedClientOptionsBuilder
implements ClientOptionsBuilder {
    protected final String clientIdName;
    protected final Properties properties;

    public MemcachedClientOptionsBuilder(ClientId clientId) {
        this(clientId, "memcached");
    }

    protected MemcachedClientOptionsBuilder(ClientId clientId, String clientTypeName) {
        this.clientIdName = clientId.getName();
        this.properties = new Properties();
        this.properties.setProperty(ClientOptions.makeClientTypeKey((String)this.clientIdName), clientTypeName);
    }

    public MemcachedClientOptionsBuilder withServers(String ... inetSocketAddresses) {
        return this.withServers(List.of(inetSocketAddresses));
    }

    public MemcachedClientOptionsBuilder withServers(List<String> inetSocketAddresses) {
        String numServersKeySuffix = MemcachedOptions.makeMemcachedKey("numServers");
        String numServersKey = this.makeKey(numServersKeySuffix);
        this.properties.setProperty(numServersKey, String.valueOf(inetSocketAddresses.size()));
        int i = 0;
        while (i < inetSocketAddresses.size()) {
            String serverKeySuffix = MemcachedOptions.makeMemcachedKey("server." + i);
            String serverKey = this.makeKey(serverKeySuffix);
            this.properties.setProperty(serverKey, inetSocketAddresses.get(i));
            ++i;
        }
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    protected String makeKey(String suffix) {
        return ClientOptions.makeClientPrefixedKey((String)this.clientIdName, (String)suffix);
    }
}

