/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.memcached.client;

import io.datarouter.client.memcached.client.BaseMemcachedClientManager;
import io.datarouter.client.memcached.client.DatarouterMemcachedClient;
import io.datarouter.client.memcached.client.MemcachedClientHolder;
import io.datarouter.client.memcached.client.SpyMemcachedClient;
import io.datarouter.client.memcached.client.options.MemcachedOptions;
import io.datarouter.storage.client.ClientId;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.KetamaConnectionFactory;

@Singleton
public class MemcachedClientManager
extends BaseMemcachedClientManager {
    private final MemcachedOptions options;

    @Inject
    public MemcachedClientManager(MemcachedClientHolder clientHolder, MemcachedOptions options) {
        super(clientHolder);
        this.options = options;
    }

    @Override
    protected DatarouterMemcachedClient buildClient(ClientId clientId) {
        KetamaConnectionFactory connectionFactory = new KetamaConnectionFactory(){

            public long getOperationTimeout() {
                return 200L;
            }
        };
        List<InetSocketAddress> addresses = this.options.getServers(clientId.getName());
        try {
            SpyMemcachedClient spyClient = new SpyMemcachedClient((ConnectionFactory)connectionFactory, this.options.getServers(clientId.getName()));
            return new DatarouterMemcachedClient(spyClient);
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("failed to build memcached client for " + addresses, e);
        }
    }
}

