/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.logging;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.LoggerConfig;

public abstract class BaseLog4j2Configuration {
    public static final String DEFAULT_PATTERN = "%d %-5level [%t] <%equals{${web:servletContextName}}{${web:servletContextName}}{%pid}> %logger{36}:%line - %msg%n%rEx";
    private static final String DEFAULT_CATALINA_OUT_DIR = "/mnt/logs";
    private static final String CATALINA_OUT_DIR_ENV_VARIABLE = "CATALINA_OUT_DIR";
    public static final String CATALINA_OUT_DIR;
    private final Map<String, Appender> appenders = new HashMap<String, Appender>();
    private final List<Filter> filters = new ArrayList<Filter>();
    private final Map<String, LoggerConfig> loggerConfigs = new HashMap<String, LoggerConfig>();

    static {
        String catalinaOutDir = System.getenv(CATALINA_OUT_DIR_ENV_VARIABLE);
        CATALINA_OUT_DIR = catalinaOutDir == null || catalinaOutDir.isEmpty() ? DEFAULT_CATALINA_OUT_DIR : catalinaOutDir;
    }

    public final Collection<Appender> getAppenders() {
        return this.appenders.values();
    }

    protected final Appender getAppender(String name) {
        return this.appenders.get(name);
    }

    protected final void addAppender(Appender appender) {
        this.appenders.put(appender.getName(), appender);
    }

    public final Collection<LoggerConfig> getLoggerConfigs() {
        return this.loggerConfigs.values();
    }

    protected final void addLoggerConfig(String name, Level level, boolean additive, Appender ... appenders) {
        this.addLoggerConfig(name, level, additive, List.of(appenders));
    }

    private final void addLoggerConfig(String name, Level level, boolean additive, Iterable<Appender> appenders) {
        LoggerConfig loggerConfig = new LoggerConfig(name, level, additive);
        appenders.forEach(appender -> loggerConfig.addAppender(appender, null, null));
        this.loggerConfigs.put(loggerConfig.getName(), loggerConfig);
    }

    protected final Collection<Filter> getFilters() {
        return this.filters;
    }

    protected final void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    protected final void registerParent(Class<? extends BaseLog4j2Configuration> clazz) {
        BaseLog4j2Configuration configuration;
        try {
            configuration = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        configuration.getAppenders().forEach(this::addAppender);
        configuration.getLoggerConfigs().forEach(loggerConfig -> this.addLoggerConfig(loggerConfig.getName(), loggerConfig.getLevel(), loggerConfig.isAdditive(), loggerConfig.getAppenders().values()));
        configuration.getFilters().forEach(this::addFilter);
    }
}

