/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.logging;

import io.datarouter.logging.BaseLog4j2Configuration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.plugins.Plugin;

@Plugin(category="ConfigurationFactory", name="StartupConfigurationFactory")
@Order(value=10)
public class StartupConfigurationFactory
extends ConfigurationFactory {
    public static final Collection<Appender> staticAppenders = new LinkedList<Appender>();
    public static final Collection<LoggerConfig> staticLoggerConfigs = new LinkedList<LoggerConfig>();

    public String[] getSupportedTypes() {
        return new String[]{".datarouter-logging"};
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        BaseLog4j2Configuration log4j2Configuration;
        String fullyQualifiedClassName;
        AbstractConfiguration configuration = new AbstractConfiguration(loggerContext, ConfigurationSource.NULL_SOURCE){};
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(source.getInputStream()));){
                fullyQualifiedClassName = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("Configuring log4j2 location={} class={}", (Object)source.getLocation(), (Object)fullyQualifiedClassName);
        try {
            Class<BaseLog4j2Configuration> configurationClass = Class.forName(fullyQualifiedClassName).asSubclass(BaseLog4j2Configuration.class);
            log4j2Configuration = configurationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        log4j2Configuration.getAppenders().forEach(arg_0 -> StartupConfigurationFactory.lambda$0((Configuration)configuration, arg_0));
        log4j2Configuration.getLoggerConfigs().forEach(arg_0 -> StartupConfigurationFactory.lambda$1((Configuration)configuration, arg_0));
        log4j2Configuration.getFilters().forEach(arg_0 -> ((Configuration)configuration).addFilter(arg_0));
        LOGGER.info("LoggingConfig initiated");
        return configuration;
    }

    private static /* synthetic */ void lambda$0(Configuration configuration, Appender appender) {
        configuration.addAppender(appender);
        staticAppenders.add(appender);
    }

    private static /* synthetic */ void lambda$1(Configuration configuration, LoggerConfig loggerConfig) {
        configuration.addLogger(loggerConfig.getName(), loggerConfig);
        staticLoggerConfigs.add(loggerConfig);
    }
}

