/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.logging;

import java.util.Arrays;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Log4j2Configurator {
    private static final Logger logger = LoggerFactory.getLogger(Log4j2Configurator.class);
    private final LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
    private final Configuration config = this.ctx.getConfiguration();
    private final LoggerConfig rootLoggerConfig;

    private static PatternLayout createLayout(String pattern) {
        return PatternLayout.newBuilder().withAlwaysWriteExceptions(false).withPattern(pattern).build();
    }

    public static ConsoleAppender createConsoleAppender(String name, ConsoleAppender.Target target, String pattern) {
        PatternLayout layout = Log4j2Configurator.createLayout(pattern);
        return ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setLayout((Layout)layout)).setTarget(target).setName(name)).build();
    }

    public static FileAppender createFileAppender(String name, String fileName, String pattern) {
        PatternLayout layout = Log4j2Configurator.createLayout(pattern);
        return ((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withFileName(fileName).setName(name)).setLayout((Layout)layout)).build();
    }

    public Log4j2Configurator() {
        org.apache.logging.log4j.Logger root = LogManager.getRootLogger();
        this.rootLoggerConfig = this.config.getLoggerConfig(root.getName());
    }

    public void updateOrCreateLoggerConfig(Class<?> clazz, Level level, boolean additive, String ... appendersRef) {
        this.updateOrCreateLoggerConfig(clazz.getName(), level, additive, appendersRef);
    }

    public void updateOrCreateLoggerConfig(Package pkg, Level level, boolean additive, String ... appendersRef) {
        this.updateOrCreateLoggerConfig(pkg.getName(), level, additive, appendersRef);
    }

    public void updateOrCreateLoggerConfig(String name, Level level, boolean additive, String ... appendersRef) {
        this.updateOrCreateLoggerConfig(name, level, additive, Arrays.asList(appendersRef));
    }

    public void updateOrCreateLoggerConfig(String name, Level level, boolean additive, Iterable<String> appendersRef) {
        LoggerConfig loggerConfig = this.config.getLoggerConfig(name);
        if (!loggerConfig.getName().equals(name)) {
            loggerConfig = new LoggerConfig(name, level, additive);
            this.config.addLogger(name, loggerConfig);
        } else {
            loggerConfig.setLevel(level);
            loggerConfig.setAdditive(additive);
        }
        if (appendersRef != null) {
            this.updateAppenders(loggerConfig, appendersRef);
        }
        this.ctx.updateLoggers();
    }

    private void updateAppenders(LoggerConfig loggerConfig, Iterable<String> appendersRef) {
        Map appenders = loggerConfig.getAppenders();
        for (String string : appenders.keySet()) {
            loggerConfig.removeAppender(string);
        }
        for (String appenderRef : appendersRef) {
            Appender appender = this.config.getAppender(appenderRef);
            if (appender != null) {
                loggerConfig.addAppender(appender, null, null);
                continue;
            }
            logger.error("Appender \"" + appenderRef + "\" not found");
        }
    }

    public void deleteLoggerConfig(String name) {
        this.config.removeLogger(name);
        this.ctx.updateLoggers();
    }

    public void deleteAppender(String name) {
        ((AbstractConfiguration)this.config).removeAppender(name);
    }

    public Map<String, LoggerConfig> getConfigs() {
        return this.config.getLoggers();
    }

    public Map<String, Appender> getAppenders() {
        return this.config.getAppenders();
    }

    public Appender getAppender(String name) {
        return this.config.getAppender(name);
    }

    public LoggerConfig getRootLoggerConfig() {
        return this.rootLoggerConfig;
    }

    public Level getRootLoggerLevel() {
        return this.config.getRootLogger().getLevel();
    }

    public void addAppender(Appender appender) {
        this.config.addAppender(appender);
    }

    public void addConsoleAppender(String name, ConsoleAppender.Target target, String pattern) {
        ConsoleAppender appender = Log4j2Configurator.createConsoleAppender(name, target, pattern);
        this.addAppender((Appender)appender);
    }

    public void addFileAppender(String name, String fileName, String pattern) {
        FileAppender appender = Log4j2Configurator.createFileAppender(name, fileName, pattern);
        this.addAppender((Appender)appender);
    }

    public void shutdown() {
        this.ctx.stop();
    }
}

