/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.web;

import io.datarouter.loadtest.service.LoadTestScanDao;
import io.datarouter.loadtest.storage.RandomValue;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.timer.PhaseTimer;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTestScanHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoadTestScanHandler.class);
    private static final String P_num = "num";
    private static final String P_batchSize = "batchSize";
    private static final String P_submitAction = "submitAction";
    private static final int DEFAULT_NUM = 100000;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    @Inject
    private LoadTestScanDao dao;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav scan(@Param(value="num") OptionalString num, @Param(value="batchSize") OptionalString batchSize, @Param(value="submitAction") OptionalString submitAction) {
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addTextField().withDisplay("Num").withName(P_num).withPlaceholder("100000").withValue((String)num.orElse(null));
        form.addTextField().withDisplay("Batch Size").withName(P_batchSize).withPlaceholder("100").withValue((String)batchSize.orElse(null));
        form.addButton().withDisplay("Run Scan").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Load Test - Scan").withContent(Html.makeContent(form)).buildMav();
        }
        PhaseTimer timer = new PhaseTimer("scan");
        int pNum = num.map(StringTool::nullIfEmpty).map(Integer::valueOf).orElse(100000);
        int pBatchSize = batchSize.map(StringTool::nullIfEmpty).map(Integer::valueOf).orElse(1000);
        AtomicInteger rowCounter = new AtomicInteger(0);
        AtomicLong lastBatchFinished = new AtomicLong(System.nanoTime());
        this.dao.scan(pBatchSize, pNum).forEach(randomValue -> LoadTestScanHandler.trackEachRow(rowCounter, lastBatchFinished, randomValue));
        timer.add("scanned " + rowCounter.get());
        String message = timer + " @" + timer.getItemsPerSecond(rowCounter.get()) + "/s";
        logger.warn(message);
        return this.pageFactory.message(this.request, message);
    }

    private static void trackEachRow(AtomicInteger rowCounter, AtomicLong lastBatchFinished, RandomValue lastRow) {
        int logBatchSize;
        int count = rowCounter.incrementAndGet();
        if (count % (logBatchSize = 1000) == 0) {
            long durationNs = System.nanoTime() - lastBatchFinished.get();
            double rpNs = (double)logBatchSize / (double)durationNs;
            double rps = rpNs * 1000.0 * 1000.0 * 1000.0;
            logger.warn("scanned {} @{}rps from {}", new Object[]{NumberFormatter.addCommas((Number)rowCounter), NumberFormatter.addCommas((Number)rps), NumberFormatter.addCommas((Number)lastRow.getK())});
            lastBatchFinished.set(System.nanoTime());
        }
    }

    private static class Html {
        private Html() {
        }

        public static ContainerTag makeContent(HtmlForm htmlForm) {
            ContainerTag form = (ContainerTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Load Test - Scan"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

