/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.storage;

import io.datarouter.loadtest.service.LoadTestScanDao;
import io.datarouter.loadtest.storage.RandomValue;
import io.datarouter.loadtest.storage.RandomValueKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterLoadTestScanDao
extends BaseDao
implements LoadTestScanDao {
    private final SortedMapStorage<RandomValueKey, RandomValue> node;

    @Inject
    public DatarouterLoadTestScanDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterLoadTestScanDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage)nodeFactory.create(params.clientId, RandomValue::new, RandomValue.RandomValueFielder::new).withTableName("LoadTestScan").buildAndRegister();
    }

    @Override
    public Scanner<RandomValue> scan(int batchSize, int limit) {
        Config config = new Config().setOutputBatchSize(Integer.valueOf(batchSize)).setNoTimeout();
        return this.node.scan(config).limit((long)limit);
    }

    public static class DatarouterLoadTestScanDaoParams
    extends BaseDaoParams {
        public DatarouterLoadTestScanDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

