/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.loadtest.util;

import io.datarouter.util.number.RandomTool;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LoadTestTool {
    public static List<Integer> makeRandomIdBatch(int totalRows, int maxId, int targetBatchSize, int batchId) {
        int thisBatchSize = LoadTestTool.adjustedBatchSize(totalRows, targetBatchSize, batchId);
        return IntStream.range(0, thisBatchSize).mapToObj($ -> RandomTool.nextPositiveInt((int)maxId)).collect(Collectors.toList());
    }

    public static List<Integer> makePredictableIdBatch(int totalRows, int targetBatchSize, int batchId) {
        int numBatches = LoadTestTool.numBatches(totalRows, targetBatchSize);
        int thisBatchSize = LoadTestTool.adjustedBatchSize(totalRows, targetBatchSize, batchId);
        return IntStream.range(0, thisBatchSize).mapToObj(i -> i * numBatches + batchId).collect(Collectors.toList());
    }

    public static int adjustedBatchSize(int totalRows, int targetBatchSize, int batchId) {
        int numBatches = LoadTestTool.numBatches(totalRows, targetBatchSize);
        int numLeftover = totalRows % numBatches;
        if (numLeftover == 0) {
            return targetBatchSize;
        }
        int numFullBatches = numLeftover;
        boolean isFullBatch = batchId < numFullBatches;
        return isFullBatch ? targetBatchSize : targetBatchSize - 1;
    }

    public static int numBatches(int totalRows, int targetBatchSize) {
        int numFullBatches = totalRows / targetBatchSize;
        boolean anyLeftover = totalRows % targetBatchSize > 0;
        return anyLeftover ? numFullBatches + 1 : numFullBatches;
    }
}

