/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import io.datarouter.instrumentation.trace.Traceparent;
import io.datarouter.instrumentation.trace.Tracestate;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class W3TraceContext {
    public static final Pattern TRACESTATE_PATTERN = Pattern.compile("^([a-z0-9_\\-*/@]*=[a-zA-Z0-9]*)(,[a-z0-9_\\-*/@]*=[a-zA-Z0-9]*)*$");
    private Traceparent traceparent;
    private Tracestate tracestate;
    private long createdTimestamp;
    private boolean hasValidTraceparent = false;

    public W3TraceContext(String traceparentStr, String tracestateStr, long createdTimestamp) {
        if (!this.validateAndSetTraceparent(traceparentStr)) {
            this.traceparent = Traceparent.generateNew(createdTimestamp);
            this.tracestate = Tracestate.generateNew(this.traceparent.parentId);
        }
        this.parseOrCreateNewTracestate(tracestateStr);
        this.createdTimestamp = createdTimestamp;
    }

    public W3TraceContext(Traceparent traceparent, Tracestate tracestate, long createdTimestamp) {
        this.traceparent = traceparent;
        this.tracestate = tracestate;
        this.createdTimestamp = createdTimestamp;
    }

    public W3TraceContext(long createdTimestamp) {
        this.traceparent = Traceparent.generateNew(createdTimestamp);
        this.tracestate = Tracestate.generateNew(this.traceparent.parentId);
        this.createdTimestamp = createdTimestamp;
    }

    public W3TraceContext copy() {
        return new W3TraceContext(this.traceparent, this.tracestate, this.createdTimestamp);
    }

    public Traceparent getTraceparent() {
        return this.traceparent;
    }

    public Tracestate getTracestate() {
        return this.tracestate;
    }

    public String getTraceId() {
        return this.traceparent.traceId;
    }

    public String getParentId() {
        return this.traceparent.parentId;
    }

    public void updateParentIdAndAddTracestateMember() {
        this.traceparent = this.traceparent.updateParentId();
        this.tracestate.addDatarouterListMember(this.traceparent.parentId);
    }

    public Optional<Long> getTimestamp() {
        if ("datarouter".equals(this.tracestate.getLastestTracestate().key)) {
            return Optional.of(this.traceparent.getTimestampInMs());
        }
        return Optional.empty();
    }

    private boolean validateAndSetTraceparent(String traceparentStr) {
        Optional<Traceparent> parsedTraceparent = Traceparent.parse(traceparentStr);
        if (parsedTraceparent.isPresent()) {
            this.traceparent = parsedTraceparent.get();
        }
        this.hasValidTraceparent = parsedTraceparent.isPresent();
        return this.hasValidTraceparent;
    }

    private void parseOrCreateNewTracestate(String tracestateStr) {
        String[] members;
        if (!this.hasValidTraceparent) {
            this.tracestate = Tracestate.generateNew(this.traceparent.parentId);
            return;
        }
        if (tracestateStr == null || tracestateStr.isEmpty()) {
            this.tracestate = Tracestate.generateNew(this.traceparent.parentId);
            return;
        }
        Matcher matcher = TRACESTATE_PATTERN.matcher(tracestateStr);
        if (!matcher.matches()) {
            this.tracestate = Tracestate.generateNew(this.traceparent.parentId);
            return;
        }
        this.tracestate = new Tracestate();
        String[] stringArray = members = tracestateStr.split(",");
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            String member = stringArray[n2];
            String[] tokens = member.split("=");
            this.tracestate.addListMember(tokens[0], tokens[1]);
            ++n2;
        }
    }

    public String toString() {
        return "traceparent=\"" + this.traceparent + "\", tracestate=\"" + this.tracestate + "\"";
    }
}

