/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Tracestate {
    public static final String TRACESTATE_DR_KEY = "datarouter";
    public static final String TRACESTATE_KEYVALUE_DELIMITER = "=";
    public static final String TRACESTATE_MEMBER_DELIMITER = ",";
    private Map<String, String> tracestateMap = new LinkedHashMap<String, String>();

    public void addDatarouterListMember(String value) {
        this.tracestateMap.put(TRACESTATE_DR_KEY, value);
    }

    public void addListMember(String key, String value) {
        this.tracestateMap.put(key, value);
    }

    public TracestateMemeber getLastestTracestate() {
        return this.tracestateMap.entrySet().stream().map(entry -> new TracestateMemeber((String)entry.getKey(), (String)entry.getValue())).findFirst().get();
    }

    public static Tracestate generateNew(String parentId) {
        Tracestate tracestate = new Tracestate();
        tracestate.addListMember(TRACESTATE_DR_KEY, parentId);
        return tracestate;
    }

    public String toString() {
        return this.tracestateMap.entrySet().stream().map(entry -> String.valueOf((String)entry.getKey()) + TRACESTATE_KEYVALUE_DELIMITER + (String)entry.getValue()).collect(Collectors.joining(TRACESTATE_MEMBER_DELIMITER));
    }

    public static class TracestateMemeber {
        public final String key;
        public final String value;

        public TracestateMemeber(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

