/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import io.datarouter.instrumentation.trace.Trace2SpanDto;
import io.datarouter.instrumentation.trace.Trace2ThreadDto;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.W3TraceContext;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;

public interface Tracer {
    public String getServerName();

    public Optional<W3TraceContext> getTraceContext();

    public BlockingQueue<Trace2ThreadDto> getThreadQueue();

    public BlockingQueue<Trace2SpanDto> getSpanQueue();

    public Long getCurrentThreadId();

    public Integer getDiscardedThreadCount();

    public void incrementDiscardedThreadCount(int var1);

    default public void createAndStartThread(String name, long queueTimeNs) {
        this.createThread(name, queueTimeNs);
        this.startThread();
    }

    public void createThread(String var1, long var2);

    public void startThread();

    public void addThread(Trace2ThreadDto var1);

    public void appendToThreadInfo(String var1);

    public void finishThread();

    public Integer getDiscardedSpanCount();

    public void startSpan(String var1, TraceSpanGroupType var2);

    public void addSpan(Trace2SpanDto var1);

    public void appendToSpanInfo(String var1);

    public void finishSpan();

    public void incrementDiscardedSpanCount(int var1);

    public Trace2SpanDto getCurrentSpan();

    public boolean shouldSample();

    public void setForceSample();

    public boolean shouldLog();

    public void setForceLog();

    public void setSaveThreadCpuTime(boolean var1);

    public void setSaveThreadMemoryAllocated(boolean var1);

    public void setSaveSpanCpuTime(boolean var1);

    public void setSaveSpanMemoryAllocated(boolean var1);

    public Tracer createChildTracer();
}

