/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import io.datarouter.instrumentation.trace.Trace2Dto;
import io.datarouter.instrumentation.trace.TraceContextFlagMask;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Pattern;

public class Traceparent {
    private static final Pattern TRACEPARENT_PATTERN = Pattern.compile("^[0-9a-f]{2}-[0-9a-f]{32}-[0-9a-f]{16}-[0-9a-f]{2}$");
    private static final String TRACEPARENT_DELIMITER = "-";
    private static final Integer MIN_CHARS_TRACEPARENT = 55;
    private static final String CURRENT_VERSION = "00";
    public static final int TRACE_ID_HEX_SIZE = 32;
    public static final int PARENT_ID_HEX_SIZE = 16;
    public final String version = "00";
    public final String traceId;
    public final String parentId;
    private String traceFlags;

    public Traceparent(String traceId, String parentId, String traceFlags) {
        this.traceId = traceId;
        this.parentId = parentId;
        this.traceFlags = traceFlags;
    }

    public Traceparent(String traceId) {
        this(traceId, Traceparent.createNewParentId());
    }

    public Traceparent(String traceId, String parentId) {
        this(traceId, parentId, Traceparent.createDefaultTraceFlag());
    }

    public static Traceparent generateNew(long createdTimestamp) {
        return new Traceparent(Traceparent.createNewTraceId(createdTimestamp), Traceparent.createNewParentId(), Traceparent.createDefaultTraceFlag());
    }

    public static Traceparent generateNewWithCurrentTimeInNs() {
        return new Traceparent(Traceparent.createNewTraceId(Trace2Dto.getCurrentTimeInNs()), Traceparent.createNewParentId(), Traceparent.createDefaultTraceFlag());
    }

    public Traceparent updateParentId() {
        return new Traceparent(this.traceId, Traceparent.createNewParentId(), this.traceFlags);
    }

    private static String createNewTraceId(long createdTimestamp) {
        return String.valueOf(String.format("%016x", createdTimestamp)) + String.format("%016x", new Random().nextLong());
    }

    public static String createNewParentId() {
        return String.format("%016x", new Random().nextLong());
    }

    public long getTimestampInMs() {
        return Long.parseLong(this.traceId.substring(0, 16), 16);
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.getTimestampInMs());
    }

    private static String createDefaultTraceFlag() {
        return TraceContextFlagMask.DEFAULT.toHexCode();
    }

    public void enableSample() {
        this.traceFlags = TraceContextFlagMask.enableTrace(this.traceFlags);
    }

    public void enableLog() {
        this.traceFlags = TraceContextFlagMask.enableLog(this.traceFlags);
    }

    public boolean shouldSample() {
        return TraceContextFlagMask.isTraceEnabled(this.traceFlags);
    }

    public boolean shouldLog() {
        return TraceContextFlagMask.isLogEnabled(this.traceFlags);
    }

    public String toString() {
        return String.join((CharSequence)TRACEPARENT_DELIMITER, CURRENT_VERSION, this.traceId, this.parentId, this.traceFlags);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Traceparent)) {
            return false;
        }
        Traceparent other = (Traceparent)obj;
        return Objects.equals(CURRENT_VERSION, other.version) && Objects.equals(this.traceId, other.traceId) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.traceFlags, other.traceFlags);
    }

    public int hashCode() {
        return Objects.hash(CURRENT_VERSION, this.traceId, this.parentId, this.traceFlags);
    }

    public static Optional<Traceparent> parse(String traceparentStr) {
        if (traceparentStr == null || traceparentStr.isEmpty()) {
            return Optional.empty();
        }
        if (traceparentStr.length() < MIN_CHARS_TRACEPARENT) {
            return Optional.empty();
        }
        if (!TRACEPARENT_PATTERN.matcher(traceparentStr).matches()) {
            return Optional.empty();
        }
        String[] tokens = traceparentStr.split(TRACEPARENT_DELIMITER);
        if (!CURRENT_VERSION.equals(tokens[0])) {
            return Optional.empty();
        }
        return Optional.of(new Traceparent(tokens[1], tokens[2], tokens[3]));
    }
}

