/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

public enum TraceContextFlagMask {
    DEFAULT(0),
    TRACE(1),
    LOG(2);

    private final byte mask;

    private TraceContextFlagMask(byte mask) {
        this.mask = mask;
    }

    public static String enableTrace(String curTraceFlags) {
        return TraceContextFlagMask.isTraceEnabled(curTraceFlags) ? curTraceFlags : TraceContextFlagMask.setFlag(curTraceFlags, TRACE);
    }

    public static String enableLog(String curTraceFlags) {
        return TraceContextFlagMask.isLogEnabled(curTraceFlags) ? curTraceFlags : TraceContextFlagMask.setFlag(curTraceFlags, LOG);
    }

    public static boolean isTraceEnabled(String hex) {
        return TraceContextFlagMask.isFlagSet(hex, TRACE);
    }

    public static boolean isLogEnabled(String hex) {
        return TraceContextFlagMask.isFlagSet(hex, LOG);
    }

    public String toHexCode() {
        return String.format("%02x", this.mask);
    }

    public byte getByteMask() {
        return this.mask;
    }

    private static boolean isFlagSet(String hexflags, TraceContextFlagMask sample) {
        if (hexflags == null || hexflags.length() < 2) {
            return false;
        }
        byte flag = (byte)Integer.parseInt(hexflags, 16);
        return (flag & sample.mask) == sample.mask;
    }

    private static String setFlag(String hexflags, TraceContextFlagMask sample) {
        if (hexflags == null || hexflags.length() < 2) {
            return hexflags;
        }
        byte flag = (byte)Integer.parseInt(hexflags, 16);
        return String.format("%02x", flag | sample.mask);
    }
}

