/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import io.datarouter.instrumentation.trace.Trace2Dto;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.Traceparent;
import java.util.Optional;

public class Trace2SpanDto {
    public final Traceparent traceparent;
    public final Long parentThreadId;
    public final Integer sequence;
    public final Integer parentSequence;
    public final String name;
    public final TraceSpanGroupType groupType;
    public final Long created;
    private String info;
    private Long ended;
    private Long cpuTimeCreatedNs;
    private Long cpuTimeEndedNs;
    private Long memoryAllocatedBytesBegin;
    private Long memoryAllocatedBytesEnded;

    public Trace2SpanDto(Traceparent traceparent, Long parentThreadId, Integer sequence, Integer parentSequence, String name, TraceSpanGroupType groupType, Long created) {
        this.traceparent = traceparent;
        this.parentThreadId = parentThreadId;
        this.sequence = sequence;
        this.parentSequence = parentSequence;
        this.name = name;
        this.groupType = groupType;
        this.created = created;
    }

    public Trace2SpanDto(Traceparent traceparent, Long parentThreadId, Integer sequence, Integer parentSequence, String name, TraceSpanGroupType groupType, String info, Long created, Long ended) {
        this(traceparent, parentThreadId, sequence, parentSequence, name, groupType, created);
        this.info = info;
        this.ended = ended;
    }

    public Traceparent getTraceparent() {
        return this.traceparent;
    }

    public Long getParentThreadId() {
        return this.parentThreadId;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public Integer getParentSequence() {
        return this.parentSequence;
    }

    public Integer getParentSequenceOrMinusOne() {
        return Optional.ofNullable(this.parentSequence).orElse(-1);
    }

    public String getName() {
        return this.name;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public Long getCreated() {
        return this.created;
    }

    public Long getEnded() {
        return this.ended;
    }

    public void markFinish() {
        this.ended = Trace2Dto.getCurrentTimeInNs();
    }

    public Long getCpuTimeCreatedNs() {
        return this.cpuTimeCreatedNs;
    }

    public void setCpuTimeCreated(Long cpuTimeCreatedNs) {
        this.cpuTimeCreatedNs = cpuTimeCreatedNs;
    }

    public Long getCpuTimeEndedNs() {
        return this.cpuTimeEndedNs;
    }

    public void setCpuTimeEndedNs(Long cpuTimeEndedNs) {
        this.cpuTimeEndedNs = cpuTimeEndedNs;
    }

    public Long getMemoryAllocatedBytesBegin() {
        return this.memoryAllocatedBytesBegin;
    }

    public void setMemoryAllocatedBegin(Long memoryAllocatedBytesBegin) {
        this.memoryAllocatedBytesBegin = memoryAllocatedBytesBegin;
    }

    public Long getMemoryAllocatedBytesEnded() {
        return this.memoryAllocatedBytesEnded;
    }

    public void setMemoryAllocatedBytesEnded(Long memoryAllocatedBytesEnded) {
        this.memoryAllocatedBytesEnded = memoryAllocatedBytesEnded;
    }
}

