/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.trace;

import io.datarouter.instrumentation.trace.Traceparent;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

public class Trace2Dto {
    public final Traceparent traceparent;
    public final String initialParentId;
    public final String context;
    public final String type;
    public final String params;
    public final Long created;
    public final Long ended;
    public final String serviceName;
    public final Integer discardedThreadCount;
    public final Integer totalThreadCount;
    public final Long cpuTimeCreatedNs;
    public final Long cpuTimeEndedNs;
    public final Long memoryAllocatedBytesBegin;
    public final Long memoryAllocatedBytesEnded;

    public Trace2Dto(Traceparent traceparent, String initialParentId, String context, String type, String params, Long created, String serviceName, Integer discardedThreadCount, Integer totalThreadCount, Long cpuTimeCreatedNs, Long cpuTimeEndedNs, Long memoryAllocatedBytesBegin, Long memoryAllocatedBytesEnded) {
        this.traceparent = traceparent;
        this.created = created;
        this.initialParentId = initialParentId;
        this.context = context;
        this.type = type;
        this.params = params;
        this.ended = Trace2Dto.getCurrentTimeInNs();
        this.serviceName = serviceName;
        this.discardedThreadCount = discardedThreadCount;
        this.totalThreadCount = totalThreadCount;
        this.cpuTimeCreatedNs = cpuTimeCreatedNs;
        this.cpuTimeEndedNs = cpuTimeEndedNs;
        this.memoryAllocatedBytesBegin = memoryAllocatedBytesBegin;
        this.memoryAllocatedBytesEnded = memoryAllocatedBytesEnded;
    }

    public long getDurationInNs() {
        return this.ended - this.created;
    }

    public long getDurationInMs() {
        return TimeUnit.NANOSECONDS.toMillis(this.getDurationInNs());
    }

    public static long getCurrentTimeInNs() {
        Instant now = Instant.now();
        return now.getEpochSecond() * 1000000000L + (long)now.getNano();
    }

    public static long convertToMsFromNsIfNecessary(long timeInMsOrNs, long createdTimeInMsOrNs) {
        boolean isTimePrecisionInMillis = createdTimeInMsOrNs < 1000000000000000L;
        return isTimePrecisionInMillis ? timeInMsOrNs : TimeUnit.NANOSECONDS.toMillis(timeInMsOrNs);
    }
}

