/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.task;

import io.datarouter.instrumentation.task.TaskStatus;
import java.time.Duration;
import java.time.Instant;

public interface TaskTracker {
    public String getName();

    public String getServerName();

    public TaskTracker setScheduledTime(Instant var1);

    public Instant getScheduledTime();

    public TaskTracker onStart();

    public TaskTracker setStartTime(Instant var1);

    public Instant getStartTime();

    public TaskTracker onFinish();

    public TaskTracker setFinishTime(Instant var1);

    public Instant getFinishTime();

    public TaskTracker heartbeat();

    public TaskTracker heartbeat(long var1);

    public TaskTracker increment();

    public TaskTracker increment(long var1);

    public long getCount();

    public TaskTracker setLastItemProcessed(String var1);

    public String getLastItem();

    public TaskTracker setStatus(TaskStatus var1);

    public TaskStatus getStatus();

    public TaskTracker requestStop();

    public boolean shouldStop();

    default public Duration getElapsedTime() {
        return Duration.between(this.getStartTime(), Instant.now());
    }
}

