/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.task;

import io.datarouter.instrumentation.task.TaskStatus;
import io.datarouter.instrumentation.task.TaskTracker;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class MemoryTaskTracker
implements TaskTracker {
    private final String name;
    private final String serverName;
    private final AtomicLong scheduledTimeMs;
    private final AtomicLong startTimeMs;
    private final AtomicLong finishTimeMs;
    private final AtomicLong lastHeartbeatMs;
    private final AtomicLong count;
    private final AtomicReference<String> lastItem;
    private final AtomicReference<TaskStatus> status;
    private final AtomicBoolean stopRequested;

    public MemoryTaskTracker(String name, String serverName, Instant scheduledTime) {
        this.name = name;
        this.serverName = serverName;
        this.scheduledTimeMs = new AtomicLong(scheduledTime.toEpochMilli());
        this.startTimeMs = new AtomicLong();
        this.finishTimeMs = new AtomicLong();
        this.lastHeartbeatMs = new AtomicLong();
        this.count = new AtomicLong();
        this.lastItem = new AtomicReference();
        this.status = new AtomicReference();
        this.stopRequested = new AtomicBoolean(false);
    }

    public MemoryTaskTracker(String name) {
        this(name, null, Instant.now());
    }

    public MemoryTaskTracker(Class<?> cls) {
        this(cls.getSimpleName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public TaskTracker setScheduledTime(Instant scheduledTime) {
        this.scheduledTimeMs.set(scheduledTime.toEpochMilli());
        return this;
    }

    @Override
    public Instant getScheduledTime() {
        return Instant.ofEpochMilli(this.scheduledTimeMs.get());
    }

    @Override
    public TaskTracker onStart() {
        this.startTimeMs.set(System.currentTimeMillis());
        return this;
    }

    @Override
    public TaskTracker setStartTime(Instant startTime) {
        this.startTimeMs.set(startTime.toEpochMilli());
        return this;
    }

    @Override
    public Instant getStartTime() {
        return Instant.ofEpochMilli(this.startTimeMs.get());
    }

    @Override
    public TaskTracker onFinish() {
        this.finishTimeMs.set(System.currentTimeMillis());
        return this;
    }

    @Override
    public TaskTracker setFinishTime(Instant finishTime) {
        this.finishTimeMs.set(finishTime.toEpochMilli());
        return this;
    }

    @Override
    public Instant getFinishTime() {
        return Instant.ofEpochMilli(this.finishTimeMs.get());
    }

    @Override
    public TaskTracker heartbeat() {
        this.lastHeartbeatMs.set(System.currentTimeMillis());
        return this;
    }

    @Override
    public TaskTracker heartbeat(long latestCount) {
        this.heartbeat();
        this.count.set(latestCount);
        return this;
    }

    @Override
    public TaskTracker increment() {
        this.count.incrementAndGet();
        return this;
    }

    @Override
    public TaskTracker increment(long incrementBy) {
        this.count.addAndGet(incrementBy);
        return this;
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public TaskTracker setLastItemProcessed(String lastItemProcessed) {
        this.heartbeat();
        this.lastItem.set(lastItemProcessed);
        return this;
    }

    @Override
    public String getLastItem() {
        return this.lastItem.get();
    }

    @Override
    public TaskTracker setStatus(TaskStatus status) {
        this.status.set(status);
        return this;
    }

    @Override
    public TaskStatus getStatus() {
        return this.status.get();
    }

    @Override
    public TaskTracker requestStop() {
        this.stopRequested.set(true);
        return this;
    }

    @Override
    public boolean shouldStop() {
        return this.stopRequested.get();
    }
}

