/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.refreshable;

import io.datarouter.instrumentation.refreshable.RefreshableSupplier;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMemoizedRefreshableSupplier<T>
implements RefreshableSupplier<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseMemoizedRefreshableSupplier.class);
    public static final Duration DEFAULT_ATTEMPT_INTERVAL = Duration.ofSeconds(15L);
    private final Duration minimumTtl;
    private final Duration attemptInterval;
    private Instant refreshInstant;
    private Instant attemptInstant;
    private T memoizedValue;

    public BaseMemoizedRefreshableSupplier(Duration minimumTtl) {
        this(minimumTtl, DEFAULT_ATTEMPT_INTERVAL);
    }

    public BaseMemoizedRefreshableSupplier(Duration minimumTtl, Duration attemptInterval) {
        if (minimumTtl.isNegative()) {
            throw new IllegalArgumentException();
        }
        if (attemptInterval.isNegative()) {
            throw new IllegalArgumentException();
        }
        this.minimumTtl = minimumTtl;
        this.attemptInterval = attemptInterval;
        this.refreshInstant = Instant.EPOCH;
        this.attemptInstant = Instant.EPOCH;
    }

    @Override
    public T get() {
        if (this.memoizedValue == null) {
            this.refresh();
        }
        return this.memoizedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instant refresh() {
        if (!this.shouldRefresh()) {
            return this.refreshInstant;
        }
        BaseMemoizedRefreshableSupplier baseMemoizedRefreshableSupplier = this;
        synchronized (baseMemoizedRefreshableSupplier) {
            this.refreshInternal();
            return this.refreshInstant;
        }
    }

    protected abstract T readNewValue();

    protected abstract String getIdentifier();

    private boolean shouldRefresh() {
        return this.refreshInstant.plus(this.minimumTtl).isBefore(Instant.now()) && this.attemptInstant.plus(this.attemptInterval).isBefore(Instant.now());
    }

    private synchronized void refreshInternal() {
        if (!this.shouldRefresh()) {
            return;
        }
        try {
            try {
                logger.debug("attempting to refresh identifier={} lastRefresh={} lastAttempt={}", new Object[]{this.getIdentifier(), this.refreshInstant, this.attemptInstant});
                T newValue = this.readNewValue();
                if (newValue == null) {
                    throw new NullPointerException();
                }
                if (!newValue.equals(this.memoizedValue)) {
                    this.memoizedValue = newValue;
                    this.refreshInstant = Instant.now();
                }
            }
            catch (RuntimeException e) {
                if (this.memoizedValue == null) {
                    throw e;
                }
                logger.warn("failed to refresh identifier={}", (Object)this.getIdentifier(), (Object)e);
                this.attemptInstant = Instant.now();
            }
        }
        finally {
            this.attemptInstant = Instant.now();
        }
    }
}

