/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.count;

import io.datarouter.instrumentation.count.CountCollector;
import java.time.Duration;
import java.util.ArrayList;

public class Counters {
    public static final long MS_IN_SECOND = Duration.ofSeconds(1L).toMillis();
    public static final long MS_IN_MINUTE = Duration.ofMinutes(1L).toMillis();
    public static final long MS_IN_HOUR = Duration.ofHours(1L).toMillis();
    public static final long MS_IN_DAY = Duration.ofDays(1L).toMillis();
    private static final ArrayList<CountCollector> COLLECTORS = new ArrayList();

    public static String getSuffix(long periodMs) {
        if (periodMs >= MS_IN_DAY) {
            return String.valueOf(periodMs / MS_IN_DAY) + "d";
        }
        if (periodMs >= MS_IN_HOUR) {
            return String.valueOf(periodMs / MS_IN_HOUR) + "h";
        }
        if (periodMs >= MS_IN_MINUTE) {
            return String.valueOf(periodMs / MS_IN_MINUTE) + "m";
        }
        if (periodMs >= MS_IN_SECOND) {
            return String.valueOf(periodMs / MS_IN_SECOND) + "s";
        }
        throw new IllegalArgumentException("unknown duration:" + periodMs);
    }

    public static void addCollector(CountCollector collector) {
        COLLECTORS.add(collector);
    }

    public static void stopAndFlushAll() {
        int i = 0;
        while (i < COLLECTORS.size()) {
            COLLECTORS.get(i).stopAndFlushAll();
            ++i;
        }
    }

    public static void inc(String key) {
        Counters.inc(key, 1L);
    }

    public static void inc(String key, long delta) {
        int i = 0;
        while (i < COLLECTORS.size()) {
            COLLECTORS.get(i).increment(key, delta);
            ++i;
        }
    }
}

